/*	Renegade Scripts.dll
	Scripts to do with cinematics
	Copyright 2006 Jonathan Wilson

	This file is part of the Renegade scripts.dll
	The Renegade scripts.dll is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2, or (at your option) any later
	version. See the file COPYING for more details.
	In addition, an exemption is given to allow Run Time Dynamic Linking of this code with any closed source module that does not contain code covered by this licence.
	Only the source code to the module(s) containing the licenced code has to be released.
*/
#include "scripts.h"
#include "jfwcine.h"

void JFW_Death_Play_Cinematic::Killed(GameObject *obj,GameObject *shooter)
{
	const char *scriptname;
	Vector3 position;
	float facing;
	GameObject *object;
	scriptname = Get_Parameter("Script_Name");
	position = Get_Vector3_Parameter("location");
	facing = Get_Float_Parameter("Facing");
	object = Commands->Create_Object("Invisible_Object",position);
	Commands->Set_Facing(object,facing);
	Commands->Attach_Script(object,"Test_Cinematic",scriptname);
}

void JFW_Zone_Play_Cinematic::Entered(GameObject *obj,GameObject *enter)
{
	const char *scriptname;
	int x;
	Vector3 position;
	float facing;
	GameObject *object;
	x = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(enter,x))
	{
		return;
	}
	scriptname = Get_Parameter("Script_Name");
	position = Get_Vector3_Parameter("location");
	facing = Get_Float_Parameter("Facing");
	object = Commands->Create_Object("Invisible_Object",position);
	Commands->Set_Facing(object,facing);
	Commands->Attach_Script(object,"Test_Cinematic",scriptname);
}

void JFW_Timer_Play_Cinematic::Created(GameObject *obj)
{
	float timertime;
	int timernumber;
	timertime = Get_Float_Parameter("Time");
	timernumber = Get_Int_Parameter("TimerNum");
	Commands->Start_Timer(obj,this,timertime,timernumber);
}

void JFW_Timer_Play_Cinematic::Timer_Expired(GameObject *obj,int number)
{
	int timernumber;
	int repeat;
	float timertime;
	const char *scriptname;
	Vector3 position;
	GameObject *object;
	float facing;
	timertime = Get_Float_Parameter("Time");
	timernumber = Get_Int_Parameter("TimerNum");
	repeat = Get_Int_Parameter("Repeat");
	scriptname = Get_Parameter("Script_Name");
	position = Get_Vector3_Parameter("location");
	facing = Get_Float_Parameter("Facing");
	if (number == timernumber)
	{
		object = Commands->Create_Object("Invisible_Object",position);
		Commands->Set_Facing(object,facing);
		Commands->Attach_Script(object,"Test_Cinematic",scriptname);
		if (repeat == 1)
		{	
			Commands->Start_Timer(obj,this,timertime,timernumber);
		}
	}
}

void JFW_Custom_Play_Cinematic::Custom(GameObject *obj,int message,int param,GameObject *sender)
{
	int msg;
	const char *scriptname;
	Vector3 position;
	GameObject *object;
	float facing;
	msg = Get_Int_Parameter("Message");
	scriptname = Get_Parameter("Script_Name");
	position = Get_Vector3_Parameter("Location");
	facing = Get_Float_Parameter("Facing");
	if (message == msg)
	{
		object = Commands->Create_Object("Invisible_Object",position);
		Commands->Set_Facing(object,facing);
		Commands->Attach_Script(object,"Test_Cinematic",scriptname);
	}
}

void JFW_Customs_Play_Cinematic::Created(GameObject *obj)
{
	if (!Get_Int_Parameter("Message1"))
	{
		custom1 = true;
	}
	else
	{
		custom1 = false;
	}
	if (!Get_Int_Parameter("Message2"))
	{
		custom2 = true;
	}
	else
	{
		custom2 = false;
	}
	if (!Get_Int_Parameter("Message3"))
	{
		custom3 = true;
	}
	else
	{
		custom3 = false;
	}
	if (!Get_Int_Parameter("Message4"))
	{
		custom4 = true;
	}
	else
	{
		custom4 = false;
	}
	if (!Get_Int_Parameter("Message5"))
	{
		custom5 = true;
	}
	else
	{
		custom5 = false;
	}
	if (!Get_Int_Parameter("Message6"))
	{
		custom6 = true;
	}
	else
	{
		custom6 = false;
	}
	if (!Get_Int_Parameter("Message7"))
	{
		custom7 = true;
	}
	else
	{
		custom7 = false;
	}
	if (!Get_Int_Parameter("Message8"))
	{
		custom8 = true;
	}
	else
	{
		custom8 = false;
	}
	trigger = false;
}

void JFW_Customs_Play_Cinematic::Custom(GameObject *obj,int message,int param,GameObject *sender)
{
	int msg;
	const char *scriptname;
	Vector3 position;
	GameObject *object;
	float facing;
	msg = Get_Int_Parameter("Message1");
	if (message == msg)
	{
		custom1 = true;
	}
	msg = Get_Int_Parameter("Message2");
	if (message == msg)
	{
		custom2 = true;
	}
	msg = Get_Int_Parameter("Message3");
	if (message == msg)
	{
		custom3 = true;
	}
	msg = Get_Int_Parameter("Message4");
	if (message == msg)
	{
		custom4 = true;
	}
	msg = Get_Int_Parameter("Message5");
	if (message == msg)
	{
		custom5 = true;
	}
	msg = Get_Int_Parameter("Message6");
	if (message == msg)
	{
		custom6 = true;
	}
	msg = Get_Int_Parameter("Message7");
	if (message == msg)
	{
		custom7 = true;
	}
	msg = Get_Int_Parameter("Message8");
	if (message == msg)
	{
		custom8 = true;
	}
	if (!trigger)
	{
		if ((custom1) && (custom2) && (custom3) && (custom4) && (custom5) && (custom6) && (custom7) && (custom8))
		{
			trigger = true;
			scriptname = Get_Parameter("Script_Name");
			position = Get_Vector3_Parameter("Location");
			facing = Get_Float_Parameter("Facing");
			object = Commands->Create_Object("Invisible_Object",position);
			Commands->Set_Facing(object,facing);
			Commands->Attach_Script(object,"Test_Cinematic",scriptname);
		}
	}
}

void JFW_Customs_Play_Cinematic::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&custom1);
	Auto_Save_Variable(2,1,&custom2);
	Auto_Save_Variable(3,1,&custom3);
	Auto_Save_Variable(4,1,&custom4);
	Auto_Save_Variable(5,1,&custom5);
	Auto_Save_Variable(6,1,&custom6);
	Auto_Save_Variable(7,1,&custom7);
	Auto_Save_Variable(8,1,&custom8);
	Auto_Save_Variable(9,1,&trigger);
}

void JFW_Looping_Cinematic::Created(GameObject *obj)
{
	const char *scriptname;
	Vector3 position;
	GameObject *object;
	float facing;
	int timernumber;
	float timertime;
	timertime = Get_Float_Parameter("Time");
	timernumber = Get_Int_Parameter("TimerNum");
	Commands->Start_Timer(obj,this,timertime,timernumber);
	scriptname = Get_Parameter("Script_Name");
	position = Get_Vector3_Parameter("Location");
	facing = Get_Float_Parameter("Facing");
	object = Commands->Create_Object("Invisible_Object",position);
	Commands->Set_Facing(object,facing);
	Commands->Attach_Script(object,"Test_Cinematic",scriptname);
}

void JFW_Looping_Cinematic::Timer_Expired(GameObject *obj,int number)
{
	const char *scriptname;
	Vector3 position;
	GameObject *object;
	float facing;
	int timernumber;
	float timertime;
	timertime = Get_Float_Parameter("Time");
	timernumber = Get_Int_Parameter("TimerNum");
	if (number == timernumber)
	{
		Commands->Start_Timer(obj,this,timertime,timernumber);
		scriptname = Get_Parameter("Script_Name");
		position = Get_Vector3_Parameter("Location");
		facing = Get_Float_Parameter("Facing");
		object = Commands->Create_Object("Invisible_Object",position);
		Commands->Set_Facing(object,facing);
		Commands->Attach_Script(object,"Test_Cinematic",scriptname);
	}
}

void JFW_Cinematic_Attack::Created(GameObject *obj)
{
	ActionParamsStruct params;
	int priority = Get_Int_Parameter("Priority");
	int targetid = Get_Int_Parameter("ID");
	float range = Get_Float_Parameter("Range");
	float deviation = Get_Float_Parameter("Deviation");
	int primary = Get_Int_Parameter("Primary");
	params.Set_Basic(this,priority,40016,-1);
	params.Set_Attack_Hold(Commands->Find_Object(targetid),range,deviation,primary,false);
	Commands->Action_Attack(obj,params);
}

void JFW_Cinematic_Attack::Action_Complete(GameObject *obj,int action,ActionCompleteReason reason)
{
	Commands->Action_Reset(obj,100);
}

void JFW_Random_Timer_Play_Cinematic::Created(GameObject *obj)
{
	float timertimemin;
	float timertimemax;
	float timertime;
	int timernumber;
	timertimemin = Get_Float_Parameter("TimeMin");
	timertimemax = Get_Float_Parameter("TimeMax");
	timertime = Commands->Get_Random(timertimemin,timertimemax);
	timernumber = Get_Int_Parameter("TimerNum");
	Commands->Start_Timer(obj,this,timertime,timernumber);
}

void JFW_Random_Timer_Play_Cinematic::Timer_Expired(GameObject *obj,int number)
{
	int timernumber;
	int repeat;
	float timertimemin;
	float timertimemax;
	float timertime;
	const char *scriptname;
	Vector3 position;
	GameObject *object;
	float facing;
	timertimemin = Get_Float_Parameter("TimeMin");
	timertimemax = Get_Float_Parameter("TimeMax");
	timertime = Commands->Get_Random(timertimemin,timertimemax);
	timernumber = Get_Int_Parameter("TimerNum");
	repeat = Get_Int_Parameter("Repeat");
	scriptname = Get_Parameter("Script_Name");
	position = Get_Vector3_Parameter("location");
	facing = Get_Float_Parameter("Facing");
	if (number == timernumber)
	{
		object = Commands->Create_Object("Invisible_Object",position);
		Commands->Set_Facing(object,facing);
		Commands->Attach_Script(object,"Test_Cinematic",scriptname);
		if (repeat == 1)
		{	
			Commands->Start_Timer(obj,this,timertime,timernumber);
		}
	}
}

void JFW_Timer_Play_Random_Cinematic::Created(GameObject *obj)
{
	float timertime;
	int timernumber;
	timertime = Get_Float_Parameter("Time");
	timernumber = Get_Int_Parameter("TimerNum");
	Commands->Start_Timer(obj,this,timertime,timernumber);
}

void JFW_Timer_Play_Random_Cinematic::Timer_Expired(GameObject *obj,int number)
{
	int timernumber;
	int repeat;
	float timertime;
	const char *scriptname;
	char sn[20];
	int random = Commands->Get_Random_Int(1,5);
	Vector3 position;
	GameObject *object;
	float facing;
	sprintf(sn,"Script_Name%d",random);
	timertime = Get_Float_Parameter("Time");
	timernumber = Get_Int_Parameter("TimerNum");
	repeat = Get_Int_Parameter("Repeat");
	scriptname = Get_Parameter(sn);
	position = Get_Vector3_Parameter("location");
	facing = Get_Float_Parameter("Facing");
	if (number == timernumber)
	{
		object = Commands->Create_Object("Invisible_Object",position);
		Commands->Set_Facing(object,facing);
		Commands->Attach_Script(object,"Test_Cinematic",scriptname);
		if (repeat == 1)
		{	
			Commands->Start_Timer(obj,this,timertime,timernumber);
		}
	}
}

void JFW_Random_Timer_Play_Random_Cinematic::Created(GameObject *obj)
{
	float timertimemin;
	float timertimemax;
	float timertime;
	int timernumber;
	timertimemin = Get_Float_Parameter("TimeMin");
	timertimemax = Get_Float_Parameter("TimeMax");
	timertime = Commands->Get_Random(timertimemin,timertimemax);
	timernumber = Get_Int_Parameter("TimerNum");
	Commands->Start_Timer(obj,this,timertime,timernumber);
}

void JFW_Random_Timer_Play_Random_Cinematic::Timer_Expired(GameObject *obj,int number)
{
	int timernumber;
	int repeat;
	float timertimemin;
	float timertimemax;
	float timertime;
	const char *scriptname;
	char sn[20];
	int random = Commands->Get_Random_Int(1,5);
	Vector3 position;
	GameObject *object;
	float facing;
	sprintf(sn,"Script_Name%d",random);
	timertimemin = Get_Float_Parameter("TimeMin");
	timertimemax = Get_Float_Parameter("TimeMax");
	timertime = Commands->Get_Random(timertimemin,timertimemax);
	timernumber = Get_Int_Parameter("TimerNum");
	repeat = Get_Int_Parameter("Repeat");
	scriptname = Get_Parameter(sn);
	position = Get_Vector3_Parameter("location");
	facing = Get_Float_Parameter("Facing");
	if (number == timernumber)
	{
		object = Commands->Create_Object("Invisible_Object",position);
		Commands->Set_Facing(object,facing);
		Commands->Attach_Script(object,"Test_Cinematic",scriptname);
		if (repeat == 1)
		{	
			Commands->Start_Timer(obj,this,timertime,timernumber);
		}
	}
}

void JFW_Cinematic_Attack_Position::Created(GameObject *obj)
{
	ActionParamsStruct params;
	int priority = Get_Int_Parameter("Priority");
	Vector3 position = Get_Vector3_Parameter("Position");
	float range = Get_Float_Parameter("Range");
	float deviation = Get_Float_Parameter("Deviation");
	int primary = Get_Int_Parameter("Primary");
	params.Set_Basic(this,priority,40016,-1);
	params.Set_Attack_Position(position,range,deviation,primary);
	Commands->Action_Attack(obj,params);
}

void JFW_Cinematic_Attack_Position::Action_Complete(GameObject *obj,int action,ActionCompleteReason reason)
{
	Commands->Action_Reset(obj,100);
}

ScriptRegistrant<JFW_Zone_Play_Cinematic> JFW_Zone_Play_Cinematic_Registrant("JFW_Zone_Play_Cinematic","Script_Name:string,location:vector3,Player_Type:int,Facing:float");
ScriptRegistrant<JFW_Death_Play_Cinematic> JFW_Death_Play_Cinematic_Registrant("JFW_Death_Play_Cinematic","Script_Name:string,location:vector3,Facing:float");
ScriptRegistrant<JFW_Timer_Play_Cinematic> JFW_Timer_Play_Cinematic_Registrant("JFW_Timer_Play_Cinematic","Time:float,TimerNum:int,Repeat:int,Script_Name:string,Location:vector3,Facing:float");
ScriptRegistrant<JFW_Custom_Play_Cinematic> JFW_Custom_Play_Cinematic_Registrant("JFW_Custom_Play_Cinematic","Message:int,Script_Name:string,Location:vector3,Facing:float");
ScriptRegistrant<JFW_Customs_Play_Cinematic> JFW_Customs_Play_Cinematic_Registrant("JFW_Customs_Play_Cinematic","Message1:int,Message2:int,Message3:int,Message4:int,Message5:int,Message6:int,Message7:int,Message8:int,Script_Name:string,Location:vector3,Facing:float");
ScriptRegistrant<JFW_Looping_Cinematic> JFW_Looping_Cinematic_Registrant("JFW_Looping_Cinematic","Script_Name:string,Location:vector3,Facing:float,Time:float,TimerNum:int");
ScriptRegistrant<JFW_Cinematic_Attack> JFW_Cinematic_Attack_Registrant("JFW_Cinematic_Attack","Priority=96:int,ID:int,Range:float,Deviation:float,Primary:int");
ScriptRegistrant<JFW_Random_Timer_Play_Cinematic> JFW_Random_Timer_Play_Cinematic_Registrant("JFW_Random_Timer_Play_Cinematic","TimeMin:float,TimeMax:float,TimerNum:int,Repeat:int,Script_Name:string,Location:vector3,Facing:float");
ScriptRegistrant<JFW_Timer_Play_Random_Cinematic> JFW_Timer_Play_Random_Cinematic_Registrant("JFW_Timer_Play_Random_Cinematic","Time:float,TimerNum:int,Repeat:int,Script_Name1:string,Script_Name2:string,Script_Name3:string,Script_Name4:string,Script_Name5:string,Location:vector3,Facing:float");
ScriptRegistrant<JFW_Random_Timer_Play_Random_Cinematic> JFW_Random_Timer_Play_Random_Cinematic_Registrant("JFW_Random_Timer_Play_Random_Cinematic","TimeMin:float,TimeMax:float,TimerNum:int,Repeat:int,Script_Name1:string,Script_Name2:string,Script_Name3:string,Script_Name4:string,Script_Name5:string,Location:vector3,Facing:float");
ScriptRegistrant<JFW_Cinematic_Attack_Position> JFW_Cinematic_Attack_Position_Registrant("JFW_Cinematic_Attack_Position","Priority=96:int,Position:vector3,Range:float,Deviation:float,Primary:int");
