/*	Renegade Scripts.dll
	SSAOW Gamelog scripts
	Copyright 2006 Mac, Jonathan Wilson

	This file is part of the Renegade scripts.dll
	The Renegade scripts.dll is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2, or (at your option) any later
	version. See the file COPYING for more details.
	In addition, an exemption is given to allow Run Time Dynamic Linking of this code with any closed source module that does not contain code covered by this licence.
	Only the source code to the module(s) containing the licenced code has to be released.
*/

#include "scripts.h"
#include "gamelog.h"
#include "engine.h"
#include <time.h>
#include "aow.h"
#include "date.h"

bool Write = true;

bool Is_Valid_Infantry (const char* Preset) {
	if (strstr(Preset,"CnC_GDI_Engineer_0")) return true;
	else if (strstr(Preset,"CnC_GDI_Grenadier_0")) return true;
	else if (strstr(Preset,"CnC_GDI_MiniGunner_0")) return true;
	else if (strstr(Preset,"CnC_GDI_MiniGunner_1Off")) return true;
	else if (strstr(Preset,"CnC_GDI_RocketSoldier_0")) return true;
	else if (strstr(Preset,"CnC_GDI_RocketSoldier_1Off")) return true;
	else if (strstr(Preset,"CnC_Nod_Engineer_0")) return true;
	else if (strstr(Preset,"CnC_Nod_FlameThrower_0")) return true;
	else if (strstr(Preset,"CnC_Nod_FlameThrower_1Off")) return true;
	else if (strstr(Preset,"CnC_Nod_Minigunner_0")) return true;
	else if (strstr(Preset,"CnC_Nod_Minigunner_1Off")) return true;
	else if (strstr(Preset,"CnC_Nod_RocketSoldier_0")) return true;
	else if (strstr(Preset,"CnC_Nod_RocketSoldier_1Off")) return true;
	else if (strcmp(Preset,"CnC_Sydney") == 0) return true;
	else if (strstr(Preset,"CnC_GDI_Engineer_2SF")) return true;
	else if (strstr(Preset,"CnC_GDI_Grenadier_2SF")) return true;
	else if (strstr(Preset,"CnC_GDI_MiniGunner_2SF")) return true;
	else if (strstr(Preset,"CnC_GDI_RocketSoldier_2SF")) return true;
	else if (strstr(Preset,"CnC_Nod_FlameThrower_2SF")) return true;
	else if (strstr(Preset,"CnC_Nod_Minigunner_2SF")) return true;
	else if (strstr(Preset,"CnC_Nod_RocketSoldier_2SF")) return true;
	else if (strstr(Preset,"CnC_Nod_Technician_0")) return true;
	else if (strstr(Preset,"CnC_Nod_Mutant_0_Mutant")) return true;
	else if (strstr(Preset,"CnC_Nod_Mutant_1Off_Acolyte")) return true;
	else if (strstr(Preset,"CnC_Nod_Mutant_2SF_Templar")) return true;
	else if (strstr(Preset,"CnC_Ignatio_Mobius")) return true;
	else if (strstr(Preset,"CnC_GDI_MiniGunner_3Boss")) return true;
	else if (strstr(Preset,"CnC_Sydney_PowerSuit")) return true;
	else if (strstr(Preset,"CnC_Nod_FlameThrower_3Boss")) return true;
	else if (strstr(Preset,"CnC_Nod_Minigunner_3Boss")) return true;
	else if (strstr(Preset,"CnC_Nod_MiniGunner_3Boss")) return true;
	else if (strstr(Preset,"CnC_Nod_RocketSoldier_3Boss")) return true;
	return false;
}

void Gamelog_Init() {
	Write = true;
		if (Settings->NewGamelog) {
			char msg[128];
			sprintf	(msg, "2.03;%s", CurrMap);
			WriteFile(msg);
			sprintf	(msg, "CONFIG;%u;%S", The_Game()->TimeLimit_Minutes, The_Game()->GameTitle.m_Buffer);
			WriteFile(msg);
			Vector3	loc;
			loc.X =	0.0f;
			loc.Y =	0.0f;
			loc.Z =	0.0f;
			GameObject *gamelog_obj	= Commands->Create_Object("Invisible_Object",loc);
			Commands->Attach_Script(gamelog_obj,"MDB_New_C4","");
			Commands->Attach_Script(gamelog_obj,"Gamelog_Scores","");
		}
		Attach_Script_All_Buildings_Team(2,"Gamelog_Building","",true);
		Attach_Script_All_DecPhys_Team(2,"Gamelog_Building","",true);
}

void Gamelog_Gameover(const char* WinType) {
	char EndMsg[70];
	sprintf(EndMsg,"WIN;%s;%s;%d;%d",The_Game()->WinnerID==0?"Nod":"GDI",WinType, int(Get_Team_Score(0)), int(Get_Team_Score(1)));
	WriteFile(EndMsg);
	Write = false;
	if (Settings->NewGamelog) {
		date logdate;
		logdate.refreshdate();
		char hours[5];
		char mins[5];
		char secs[5];
		char months[5];
		char days[5];
		char years[5];
		time_t rawtime;
		struct tm *timeinfo;
		time(&rawtime);
		timeinfo = localtime(&rawtime);
		int	hour = timeinfo->tm_hour;
		int	min	= timeinfo->tm_min;
		int	sec	= timeinfo->tm_sec;
		int	day	= timeinfo->tm_mday;
		int	month =	timeinfo->tm_mon;
		int	year = timeinfo->tm_year;
		if (hour < 10) sprintf(hours,"0%d",hour);
		else sprintf(hours,"%d",hour);
		if (min	< 10) sprintf(mins,"0%d",min);
		else sprintf(mins,"%d",min);
		if (sec	< 10) sprintf(secs,"0%d",sec);
		else sprintf(secs,"%d",sec);
		if (day	< 10) sprintf(days,"0%d",day);
		else sprintf(days,"%d",day);
		if (month <	10)	sprintf(months,"0%d",month);
		else sprintf(months,"%d",sec);
		if (year < 1900) year = year + 1900;
		sprintf(years,"%d",year);
		char fileName[256];
		sprintf	(fileName, "gamelog_%s_%s_%s_%s_%s.txt",CurrMap,logdate.get_date_string(),hours,mins,secs);
		if (Settings->Gamelog_Archive_Logfiles) {
			rename(	"gamelog2.txt" , fileName );
		}
		else {
			remove ("gamelog2.txt");
		}
	}
}

void GamelogObjectHook(GameObject *obj) {
	if (Is_Vehicle(obj)) {
		if (!Is_DecorationPhys(obj)) {
			Attach_Script_Once(obj,"Gamelog_Vehicle","");
		}
		else  {
			Attach_Script_Once(obj,"Gamelog_Building","");
		}
	}
	else if (Is_Soldier(obj)) {
		Attach_Script_Once(obj,"Gamelog_Soldier","");
	}

	if (Settings->NewGamelog) {
		if (Is_Beacon(obj)) {
			Attach_Script_Once(obj,"Gamelog_Beacon","");
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"Crate") || strstr(Commands->Get_Preset_Name(obj),"crate")) {
			Attach_Script_Once(obj,"Gamelog_Crate","");
		}
	}
}


void Gamelog_Scores::Created(GameObject	*obj)
{
	Commands->Start_Timer(obj,this,60.0f,1);
}

void Gamelog_Scores::Timer_Expired(GameObject *obj,	int	number)
{
	if (number == 1)
	{
		Commands->Start_Timer(obj,this,60.0f,1);
		int	x =	The_Game()->MaxPlayers;
		for	(int j = 1;j <=	x;j++) {
			GameObject *player = Get_GameObj(j);
			if (player) {
				char tmp[128];
				sprintf	(tmp, "SCORE;%d;%d;%d",	Commands->Get_ID(player), int(Commands->Get_Points(player)), int(Commands->Get_Money(player)));
				WriteFile(tmp);
			}
		}
	}
}

void Gamelog_Scores::Custom(GameObject *obj, int message, int param, GameObject	*sender)
{
	if (message	== 200)
	{
		Timer_Expired(obj, 1);
	}
}

void WriteFile (const char*	Message) {
	if (Settings->NewGamelog && !Write) return;
	char FDSlogname[100];
	if (Settings->NewGamelog) {
		sprintf(FDSlogname,	"gamelog2.txt");
	}
	else {
		sprintf(FDSlogname,	"gamelog.txt");
	}

	FILE *FP;
	if ( (FP = fopen( FDSlogname, "a"))	== NULL	)
		return;
	char messageprint[512];
	char hours[5];
	char mins[5];
	char secs[5];
	time_t rawtime;
	struct tm *timeinfo;
	time(&rawtime);
	timeinfo = localtime(&rawtime);
	int	hour = timeinfo->tm_hour;
	int	min	= timeinfo->tm_min;
	int	sec	= timeinfo->tm_sec;
	if (hour < 10) sprintf(hours,"0%d",hour);
	else sprintf(hours,"%d",hour);
	if (min	< 10) sprintf(mins,"0%d",min);
	else sprintf(mins,"%d",min);
	if (sec	< 10) sprintf(secs,"0%d",sec);
	else sprintf(secs,"%d",sec);
	if (Settings->MergeGamelogRenlog) {
		FDSMessage(Message,"_GAMELOG");
	}
	else {
		sprintf(messageprint,"[%s:%s:%s] %s\n",hours,mins,secs,Message);
	}
	fputs(messageprint,	FP);
	fclose(FP);
}

void Gamelog_Building::Created(GameObject *obj)
{
	char Message[512];
	Vector3	pos;
	pos	= Commands->Get_Position(obj);
	sprintf	(Message, "CREATED;BUILDING;%d;%s;%d;%d;%d;%d;%f;%f;%d", Commands->Get_ID(obj),	Commands->Get_Preset_Name(obj),	int(pos.Y),int(pos.X),int(pos.Z), int(Commands->Get_Facing(obj)), Commands->Get_Max_Health(obj),Commands->Get_Max_Shield_Strength(obj),Get_Object_Type(obj));
	WriteFile(Message);
}

void Gamelog_Building::Destroyed(GameObject	*obj)
{
	char Message[512];
	Vector3	pos;
	pos	= Commands->Get_Position(obj);
	sprintf	(Message, "DESTROYED;BUILDING;%d;%s;%d;%d;%d", Commands->Get_ID(obj), Commands->Get_Preset_Name(obj), int(pos.Y), int(pos.X), int(pos.Z));
	WriteFile(Message);
}

void Gamelog_Building::Damaged(GameObject *obj,	GameObject *damager, float damage)
{
	if (damage != 0)
	{
		Vector3	victimpos;
		Vector3	damagerpos;
		victimpos =	Commands->Get_Position(obj);
		damagerpos = Commands->Get_Position(damager);
		char Message[512];
		sprintf	(Message, "DAMAGED;BUILDING;%d;%s;%d;%d;%d;%d;%d;%s;%d;%d;%d;%d;%f;%d;%d;%d", Commands->Get_ID(obj), Commands->Get_Preset_Name(obj), int(victimpos.Y), int(victimpos.X), int(victimpos.Z), int(Commands->Get_Facing(obj)), Commands->Get_ID(damager), Commands->Get_Preset_Name(damager), int(damagerpos.Y), int(damagerpos.X),	int(damagerpos.Z), int(Commands->Get_Facing(damager)), damage, int(Commands->Get_Health(obj)), int(Commands->Get_Shield_Strength(obj)),	int(Commands->Get_Points(obj)));
		WriteFile(Message);
	}
}

void Gamelog_Building::Killed(GameObject *obj, GameObject *shooter)
{
	char Message[512];
	Vector3	victimpos;
	Vector3	damagerpos;
	victimpos =	Commands->Get_Position(obj);
	damagerpos = Commands->Get_Position(shooter);
	char CurWep[50];
	sprintf(CurWep,"0");
	if (Is_Valid_Infantry(Commands->Get_Preset_Name(shooter))) strncpy(CurWep,Get_Current_Weapon(shooter),49);
	
	sprintf	(Message, "KILLED;BUILDING;%d;%s;%d;%d;%d;%d;%d;%s;%d;%d;%d;%d;%s",	Commands->Get_ID(obj), Commands->Get_Preset_Name(obj), int(victimpos.Y), int(victimpos.X), int(victimpos.Z), int(Commands->Get_Facing(obj)), Commands->Get_ID(shooter),	Commands->Get_Preset_Name(shooter),	int(damagerpos.Y), int(damagerpos.X), int(damagerpos.Z), int(Commands->Get_Facing(shooter)),CurWep);
	WriteFile(Message);
}

void Gamelog_Soldier::Created(GameObject *obj)
{
	char Message[512];
	Vector3	pos;
	pos	= Commands->Get_Position(obj);
	sprintf	(Message, "CREATED;SOLDIER;%d;%s;%d;%d;%d;%d;%d;%d;%d;%s", Commands->Get_ID(obj),	Commands->Get_Preset_Name(obj),	int(pos.Y),int(pos.X),int(pos.Z), int(Commands->Get_Facing(obj)), int(Commands->Get_Max_Health(obj)),int(Commands->Get_Max_Shield_Strength(obj)),Commands->Get_Player_Type(obj),Get_Player_Name(obj));
	WriteFile(Message);
	Commands->Start_Timer(obj,this,2.0f,1);
}

void Gamelog_Soldier::Destroyed(GameObject *obj)
{
	char Message[512];
	Vector3	pos;
	pos	= Commands->Get_Position(obj);
	sprintf	(Message, "DESTROYED;SOLDIER;%d;%s;%d;%d;%d;%d", Commands->Get_ID(obj),	Commands->Get_Preset_Name(obj),	int(pos.Y),	int(pos.X),	int(pos.Z),	int(Commands->Get_Points(obj)));
	WriteFile(Message);
}

void Gamelog_Soldier::Damaged(GameObject *obj, GameObject *damager,	float damage)
{
	if (damage != 0)
	{
		Vector3	victimpos;
		Vector3	damagerpos;
		victimpos =	Commands->Get_Position(obj);
		damagerpos = Commands->Get_Position(damager);
		char Message[512];
		sprintf	(Message, "DAMAGED;SOLDIER;%d;%s;%d;%d;%d;%d;%d;%s;%d;%d;%d;%d;%f;%d;%d;%d", Commands->Get_ID(obj),	Commands->Get_Preset_Name(obj),	int(victimpos.Y), int(victimpos.X),	int(victimpos.Z), int(Commands->Get_Facing(obj)), Commands->Get_ID(damager), Commands->Get_Preset_Name(damager), int(damagerpos.Y),	int(damagerpos.X), int(damagerpos.Z), int(Commands->Get_Facing(damager)), damage, int(Commands->Get_Health(obj)), int(Commands->Get_Shield_Strength(obj)), int(Commands->Get_Points(damager)));
		WriteFile(Message);
	}
}

void Gamelog_Soldier::Killed(GameObject	*obj, GameObject *shooter)
{
	char Message[512];
	Vector3	victimpos;
	Vector3	damagerpos;
	victimpos =	Commands->Get_Position(obj);
	damagerpos = Commands->Get_Position(shooter);
	char CurWep[50];
	sprintf(CurWep,"0");
	if (Is_Valid_Infantry(Commands->Get_Preset_Name(shooter))) strncpy(CurWep,Get_Current_Weapon(shooter),49);

	sprintf	(Message, "KILLED;SOLDIER;%d;%s;%d;%d;%d;%d;%d;%s;%d;%d;%d;%d;%s", Commands->Get_ID(obj), Commands->Get_Preset_Name(obj), int(victimpos.X),	int(victimpos.Y), int(victimpos.Z),	int(Commands->Get_Facing(obj)),	Commands->Get_ID(shooter), Commands->Get_Preset_Name(shooter), int(damagerpos.X), int(damagerpos.Y), int(damagerpos.Z),	int(Commands->Get_Facing(shooter)),	CurWep);
	WriteFile(Message);
}

void Gamelog_Soldier::Timer_Expired(GameObject *obj, int number)
{
	if (number == 1)
	{
		char Message[512];
		Commands->Start_Timer(obj,this,2.0f,1);
		Vector3	pos;
		pos	= Commands->Get_Position(obj);
		sprintf	(Message, "POS;SOLDIER;%d;%s;%d;%d;%d;%d;%d;%d", Commands->Get_ID(obj),	Commands->Get_Preset_Name(obj),	int(pos.Y),int(pos.X),int(pos.Z), int(Commands->Get_Facing(obj)), int(Commands->Get_Health(obj)), int(Commands->Get_Shield_Strength(obj)));
		WriteFile(Message);
	}
}

void Gamelog_Vehicle::Custom(GameObject	*obj, int message, int param, GameObject *sender)
{
	if (message	== CUSTOM_EVENT_VEHICLE_ENTER)
	{
		char Message[512];
		Vector3	pos;
		Vector3	senderpos;
		pos	= Commands->Get_Position(obj);
		senderpos =	Commands->Get_Position(sender);
		sprintf	(Message, "ENTER;%d;%s;%d;%d;%d;%d;%s;%d;%d;%d", Commands->Get_ID(obj),	Commands->Get_Preset_Name(obj),	int(pos.Y),	int(pos.X),	int(pos.Z),	Commands->Get_ID(sender), Commands->Get_Preset_Name(sender), int(senderpos.Y), int(senderpos.X), int(senderpos.Z));
		WriteFile(Message);
	}
	if (message	== CUSTOM_EVENT_VEHICLE_EXIT)
	{
		char Message[512];
		Vector3	pos;
		Vector3	senderpos;
		pos	= Commands->Get_Position(obj);
		senderpos =	Commands->Get_Position(obj);
		sprintf	(Message, "EXIT;%d;%s;%d;%d;%d;%d;%s;%d;%d;%d",	Commands->Get_ID(obj), Commands->Get_Preset_Name(obj), int(pos.Y), int(pos.X), int(pos.Z), Commands->Get_ID(sender), Commands->Get_Preset_Name(sender),	int(senderpos.Y), int(senderpos.X),	int(senderpos.Z));
		WriteFile(Message);
	}
}

void Gamelog_Vehicle::Created(GameObject *obj)
{
	char Message[512];
	Vector3	pos;
	pos	= Commands->Get_Position(obj);
	sprintf	(Message, "CREATED;VEHICLE;%d;%s;%d;%d;%d;%d;%d;%d;%d",	Commands->Get_ID(obj), Commands->Get_Preset_Name(obj), int(pos.Y),int(pos.X),int(pos.Z), int(Commands->Get_Facing(obj)), int(Commands->Get_Max_Health(obj)),int(Commands->Get_Max_Shield_Strength(obj)), Commands->Get_Player_Type(obj));
	WriteFile(Message);
	Commands->Start_Timer(obj,this,2.0f,1);
}

void Gamelog_Vehicle::Destroyed(GameObject *obj)
{
	char Message[512];
	Vector3	pos;
	pos	= Commands->Get_Position(obj);
	sprintf	(Message, "DESTROYED;VEHICLE;%d;%s;%d;%d;%d", Commands->Get_ID(obj), Commands->Get_Preset_Name(obj), int(pos.Y), int(pos.X), int(pos.Z));
	WriteFile(Message);
}

void Gamelog_Vehicle::Damaged(GameObject *obj, GameObject *damager,	float damage)
{
	Vector3	victimpos;
	Vector3	damagerpos;
	victimpos =	Commands->Get_Position(obj);
	damagerpos = Commands->Get_Position(damager);
	if (damage != 0)
	{
		char Message[512];
		sprintf	(Message, "DAMAGED;VEHICLE;%d;%s;%d;%d;%d;%d;%d;%s;%d;%d;%d;%d;%f;%d;%d;%d", Commands->Get_ID(obj),	Commands->Get_Preset_Name(obj),	int(victimpos.Y), int(victimpos.X),	int(victimpos.Z), int(Commands->Get_Facing(obj)), Commands->Get_ID(damager), Commands->Get_Preset_Name(damager), int(damagerpos.Y),	int(damagerpos.X), int(damagerpos.Z), int(Commands->Get_Facing(damager)), damage, int(Commands->Get_Health(obj)), int(Commands->Get_Shield_Strength(obj)), int(Commands->Get_Points(damager)));
		WriteFile(Message);
	}
}

void Gamelog_Vehicle::Killed(GameObject	*obj, GameObject *shooter)
{
	char Message[512];
	Vector3	victimpos;
	Vector3	damagerpos;
	victimpos =	Commands->Get_Position(obj);
	damagerpos = Commands->Get_Position(shooter);
	char CurWep[50];
	sprintf(CurWep,"0");
	if (Is_Valid_Infantry(Commands->Get_Preset_Name(shooter))) strncpy(CurWep,Get_Current_Weapon(shooter),49);

	sprintf	(Message, "KILLED;VEHICLE;%d;%s;%d;%d;%d;%d;%d;%s;%d;%d;%d;%d;%s", Commands->Get_ID(obj), Commands->Get_Preset_Name(obj), int(victimpos.Y),	int(victimpos.X), int(victimpos.Z),	int(Commands->Get_Facing(obj)),	Commands->Get_ID(shooter), Commands->Get_Preset_Name(shooter), int(damagerpos.Y), int(damagerpos.X), int(damagerpos.Z),	int(Commands->Get_Facing(shooter)),	CurWep);
	WriteFile(Message);
}

void Gamelog_Vehicle::Timer_Expired(GameObject *obj, int number)
{
	if (number == 1)
	{
		char Message[512];
		Commands->Start_Timer(obj,this,2.0f,1);
		Vector3	pos;
		pos	= Commands->Get_Position(obj);
		sprintf	(Message, "POS;VEHICLE;%d;%s;%d;%d;%d;%d;%d;%d", Commands->Get_ID(obj),	Commands->Get_Preset_Name(obj),	int(pos.Y),int(pos.X),int(pos.Z), int(Commands->Get_Facing(obj)), int(Commands->Get_Health(obj)), int(Commands->Get_Shield_Strength(obj)));
		WriteFile(Message);
	}
}

void Gamelog_Mine::Custom(GameObject *obj, int message,	int	param, GameObject *sender) {
	if (message	== 500) {
		char Message[512];
		Vector3 pos = Commands->Get_Position(obj);
		if (Get_C4_Mode(obj) == 2) {
			sprintf(type,"Timed C4");
		}
		else if (Get_C4_Mode(obj) == 1) {
			sprintf(type,"Remote C4");
		}
		else if (Get_C4_Mode(obj) == 3) {
			sprintf(type,"Proxy");
		}
		sprintf	(Message, "CREATED;OBJECT;%d;%s;%d;%d;%d;%d;%d;%d;%d", Commands->Get_ID(obj), type,	int(pos.Y),int(pos.X),int(pos.Z), int(Commands->Get_Facing(obj)), int(Commands->Get_Max_Health(obj)), int(Commands->Get_Max_Shield_Strength(obj)), Get_Object_Type(obj));
		WriteFile(Message);
	}
}

void Gamelog_Mine::Destroyed(GameObject	*obj) {
	char Message[512];
	Vector3	pos = Commands->Get_Position(obj);
	sprintf	(Message, "DESTROYED;OBJECT;%d;%s;%d;%d;%d", Commands->Get_ID(obj),	type, int(pos.Y), int(pos.X), int(pos.Z));
	WriteFile(Message);
}

void Gamelog_Mine::Damaged(GameObject *obj,	GameObject *damager, float damage) {
	if (damage != 0) {
		Vector3	victimpos =	Commands->Get_Position(obj);
		Vector3	damagerpos = Commands->Get_Position(damager);
		char Message[512];
		sprintf	(Message, "DAMAGED;OBJECT;%d;%s;%d;%d;%d;%d;%d;%s;%d;%d;%d;%d;%f;%d;%d", Commands->Get_ID(obj),	type, int(victimpos.Y),	int(victimpos.X), int(victimpos.Z),	int(Commands->Get_Facing(obj)),	Commands->Get_ID(damager), Commands->Get_Preset_Name(damager), int(damagerpos.Y), int(damagerpos.X), int(damagerpos.Z),	int(Commands->Get_Facing(damager)),	damage,	int(Commands->Get_Health(obj)),	int(Commands->Get_Shield_Strength(obj)));
		WriteFile(Message);
	}
}

void Gamelog_Mine::Killed(GameObject *obj, GameObject *shooter) {
	char Message[512];
	Vector3	victimpos =	Commands->Get_Position(obj);
	Vector3	damagerpos = Commands->Get_Position(shooter);
	sprintf	(Message, "KILLED;OBJECT;%d;%s;%d;%d;%d;%d;%d;%s;%d;%d;%d;%d", Commands->Get_ID(obj), type,	int(victimpos.Y), int(victimpos.X),	int(victimpos.Z), int(Commands->Get_Facing(obj)), Commands->Get_ID(shooter), Commands->Get_Preset_Name(shooter), int(damagerpos.Y),	int(damagerpos.X), int(damagerpos.Z), int(Commands->Get_Facing(shooter)));
	WriteFile(Message);
}

void MDB_New_C4::Created(GameObject	*obj) {
	if (stricmp(Commands->Get_Preset_Name(obj),"Invisible_Object") == 0) {
		Commands->Start_Timer(obj,this,0.1f,2);
	}
}
void MDB_New_C4::Timer_Expired(GameObject *obj,	int	number) {
	if (number == 2) {
		Track_New_C4();
		Commands->Start_Timer(obj,this,0.3f,2);
	}
}

void MDB_New_C4::Custom(GameObject *obj, int message, int param, GameObject	*sender) {
	if (message	== 9955) {
		Commands->Attach_Script(obj,"Gamelog_Mine","");
		Commands->Send_Custom_Event(obj,obj,500,0,0);
	}
}

void Gamelog_Beacon::Created(GameObject	*obj) {
	char Message[512];
	Vector3	pos;
	pos	= Commands->Get_Position(obj);
	sprintf	(Message, "CREATED;OBJECT;%d;%s;%d;%d;%d;%d;%d;%d;%d", Commands->Get_ID(obj), Commands->Get_Preset_Name(obj), int(pos.Y),int(pos.X),int(pos.Z),	int(Commands->Get_Facing(obj)),	int(Commands->Get_Max_Health(obj)),int(Commands->Get_Max_Shield_Strength(obj)),	Commands->Get_Player_Type(obj));
	WriteFile(Message);
}

void Gamelog_Beacon::Destroyed(GameObject *obj)
{
	char Message[512];
	Vector3	pos;
	pos	= Commands->Get_Position(obj);
	sprintf	(Message, "DESTROYED;OBJECT;%d;%s;%d;%d;%d", Commands->Get_ID(obj),	int(Commands->Get_Preset_Name(obj)), int(pos.Y), int(pos.X), int(pos.Z));
	WriteFile(Message);
}

void Gamelog_Beacon::Damaged(GameObject	*obj, GameObject *damager, float damage)
{
	Vector3	victimpos;
	Vector3	damagerpos;
	victimpos =	Commands->Get_Position(obj);
	damagerpos = Commands->Get_Position(damager);
	if (damage != 0)
	{
		char Message[512];
		sprintf	(Message, "DAMAGED;OBJECT;%d;%s;%d;%d;%d;%d;%d;%s;%d;%d;%d;%d;%f;%d;%d", Commands->Get_ID(obj),	Commands->Get_Preset_Name(obj),	int(victimpos.Y), int(victimpos.X),	int(victimpos.Z), int(Commands->Get_Facing(obj)), Commands->Get_ID(damager), Commands->Get_Preset_Name(damager), int(damagerpos.Y),	int(damagerpos.X), int(damagerpos.Z), int(Commands->Get_Facing(damager)), damage, int(Commands->Get_Health(obj)), int(Commands->Get_Shield_Strength(obj)));
		WriteFile(Message);
	}
}

void Gamelog_Beacon::Killed(GameObject *obj, GameObject	*shooter)
{
	char Message[512];
	Vector3	victimpos;
	Vector3	damagerpos;
	victimpos =	Commands->Get_Position(obj);
	damagerpos = Commands->Get_Position(shooter);
	sprintf	(Message, "KILLED;OBJECT;%d;%s;%d;%d;%d;%d;%d;%s;%d;%d;%d;%d", Commands->Get_ID(obj), Commands->Get_Preset_Name(obj), int(victimpos.Y),	int(victimpos.X), int(victimpos.Z),	int(Commands->Get_Facing(obj)),	Commands->Get_ID(shooter), Commands->Get_Preset_Name(shooter), int(damagerpos.Y), int(damagerpos.X), int(damagerpos.Z),	int(Commands->Get_Facing(shooter)));
	WriteFile(Message);
}

void Gamelog_Chat_Hook(int PlayerID, int Type, const wchar_t *Message)
{
	if (Settings->Gamelog)
	{
		GameObject *player = Get_GameObj(PlayerID);
		char msg[512];
		char type[8];
		if (Type ==	0)
			sprintf(type,"PUBLIC");
		else if (Type == 1)
			sprintf(type,"TEAM");
#ifdef WIN32
		sprintf(msg, "CHAT;%s;%d;%S", type, Commands->Get_ID(player), Message);
#else
		sprintf(msg, "CHAT;%s;%d;%ls", type, Commands->Get_ID(player), Message);
#endif
		WriteFile(msg);
	}
}

void Gamelog_Crate::Created(GameObject *obj)
{
	char Message[512];
	Vector3	pos;
	pos	= Commands->Get_Position(obj);
	sprintf	(Message, "CREATED;CRATE;%d;%s;%d;%d;%d;%d;%d;%d;%d", Commands->Get_ID(obj), Commands->Get_Preset_Name(obj), int(pos.Y),int(pos.X),int(pos.Z), int(Commands->Get_Facing(obj)), int(Commands->Get_Max_Health(obj)),int(Commands->Get_Max_Shield_Strength(obj)), int(Commands->Get_Player_Type(obj)));
	WriteFile(Message);
}

void Gamelog_Crate::Destroyed(GameObject *obj)
{
	char Message[512];
	Vector3	pos;
	pos	= Commands->Get_Position(obj);
	sprintf	(Message, "DESTROYED;CRATE;%d;%s;%d;%d;%d",	Commands->Get_ID(obj), Commands->Get_Preset_Name(obj), int(pos.Y), int(pos.X), int(pos.Z));
	WriteFile(Message);
}

void Gamelog_Crate::Damaged(GameObject *obj, GameObject	*damager, float	damage)
{
	Vector3	victimpos;
	Vector3	damagerpos;
	victimpos =	Commands->Get_Position(obj);
	damagerpos = Commands->Get_Position(damager);
	if (damage != 0)
	{
		char Message[512];
		sprintf	(Message, "DAMAGED;CRATE;%d;%s;%d;%d;%d;%d;%d;%s;%d;%d;%d;%d;%f;%d;%d",	Commands->Get_ID(obj), Commands->Get_Preset_Name(obj), int(victimpos.Y), int(victimpos.X), int(victimpos.Z), int(Commands->Get_Facing(obj)), Commands->Get_ID(damager),	Commands->Get_Preset_Name(damager),	int(damagerpos.Y), int(damagerpos.X), int(damagerpos.Z),int(Commands->Get_Facing(damager)),	damage,	int(Commands->Get_Health(obj)),	int(Commands->Get_Shield_Strength(obj)));
		WriteFile(Message);
	}
}

void Gamelog_Crate::Killed(GameObject *obj,	GameObject *shooter)
{
	char Message[512];
	Vector3	victimpos;
	Vector3	damagerpos;
	victimpos =	Commands->Get_Position(obj);
	damagerpos = Commands->Get_Position(shooter);
	sprintf	(Message, "KILLED;CRATE;%d;%s;%d;%d;%d;%d;%d;%s;%f;%f;%f;%f", Commands->Get_ID(obj), Commands->Get_Preset_Name(obj), int(victimpos.Y), int(victimpos.X), int(victimpos.Z), int(Commands->Get_Facing(obj)), Commands->Get_ID(shooter), Commands->Get_Preset_Name(shooter), int(damagerpos.Y), int(damagerpos.X),	int(damagerpos.Z), int(Commands->Get_Facing(shooter)));
	WriteFile(Message);
}

ScriptRegistrant<Gamelog_Building> Gamelog_Building_Registrant("Gamelog_Building","");
ScriptRegistrant<Gamelog_Soldier> Gamelog_Soldier_Registrant("Gamelog_Soldier","");
ScriptRegistrant<Gamelog_Vehicle> Gamelog_Vehicle_Registrant("Gamelog_Vehicle","");
ScriptRegistrant<Gamelog_Mine> Gamelog_Mine_Registrant("Gamelog_Mine","");
ScriptRegistrant<Gamelog_Beacon> Gamelog_Beacon_Registrant("Gamelog_Beacon","");
ScriptRegistrant<Gamelog_Crate>	Gamelog_Crate_Registrant("Gamelog_Crate","");
ScriptRegistrant<Gamelog_Scores> Gamelog_Scores_Registrant("Gamelog_Scores","");
ScriptRegistrant<MDB_New_C4> MDB_New_C4_Registrant("MDB_New_C4","");

