#include "xproxy.h"
#include "frame.h"
#include "manager.h"
#include "dns.h"
#include "settings.h"

xProxySettings::xProxySettings(bool init)
	: m_init(init),
	  m_CfgCheckCounter(-1.0f),
	  m_CfgModTime(0)
{
	this->Think();
}
void xProxySettings::Delete()
{
}
void xProxySettings::Think()
{
	this->m_CfgCheckCounter -= xProxyFrameManager::GetFrameTime();
	if (this->m_CfgCheckCounter < 0.0f)
	{
		struct stat attrib;
		stat("xProxy.cfg", &attrib);
		if (this->m_CfgModTime != attrib.st_mtime)
		{
			if (this->m_CfgModTime > 0)
				Log("Settings have been changed. Reloading...");

			this->m_CfgFile.Load("xProxy.cfg");
			this->m_dnsIP = this->m_CfgFile.GetData("xProxy.DNS", "8.8.8.8");
#if VERCL(0, 9, 0)
			this->m_serverIP = this->m_CfgFile.GetData("xProxy.ServerIP");
#endif
			this->m_fakePing = (this->m_CfgFile.GetData("xProxy.FakePing") == "0" ? false : true);
			this->m_blockDuplicate = (this->m_CfgFile.GetData("xProxy.BlockDuplicate") == "0" ? false : true);
			this->m_writeLog = (this->m_CfgFile.GetData("xProxy.WriteLog") == "0" ? false : true);

			this->m_ignoreUsers.Clear();
			for (int i = 1; i <= this->m_CfgFile.GetSubCount("xProxy.IgnoreUsers"); i++)
				this->m_ignoreUsers.Add(this->m_CfgFile.GetItem(aString::Format("xProxy.IgnoreUsers[%d]", i)));

			this->m_allowFdsIP.Clear();
			for (int i = 1; i <= this->m_CfgFile.GetSubCount("xProxy.AllowFdsIP"); i++)
				this->m_allowFdsIP.Add(this->m_CfgFile.GetItem(aString::Format("xProxy.AllowFdsIP[%d]", i)));

			if (this->m_allowFdsIP.Count() == 0)
			{
#if VERC(1, 0, 0)
				Log("Allowed FDS IP list is empty, setting to default...");
#else
				Log("Do you really want to prevent all IP from connecting to xProxy?");
#endif
				this->m_allowFdsIP.Add("*");
			}

#if VERC(1, 0, 0)
			if (xProxyManager::m_dns != NULL)
				xProxyManager::m_dns->SetServer(this->m_dnsIP);
#endif

			if (!this->m_init)
			{
				this->ShowSettings();
				this->m_init = false;
			}

			this->m_CfgModTime = attrib.st_mtime;
		}
		this->m_CfgCheckCounter = CFG_RELOAD_TIME;
	}
}
void xProxySettings::ShowSettings()
{
	Log("------------------------------");
	Log("Current settings:");
	Log("DNS: %s", this->m_dnsIP.GetString());
#if VERCL(0, 9, 0)
	Log("XWIS server IP: %s", this->m_serverIP.GetString());
#endif
	Log("Fake ping: %s", this->m_fakePing ? "Yes" : "No");
	Log("Block duplicate: %s", this->m_blockDuplicate ? "Yes" : "No");
	Log("Write to log: %s", this->m_writeLog ? "Yes" : "No");
	Log("Users blocked: %d", this->m_ignoreUsers.Count());
	Log("Allowed IP items: %d", this->m_allowFdsIP.Count());
	Log("------------------------------");
}
