#ifndef __RS__
#define __RS__

#include <winsock2.h>
#include <vector>
#include "fds.h"

//#define __DEV__
#define MINIMUM_HOOKS_VERSION 1.04
#define VERSION_STATE "1.0"

// Data structure
struct ReservedSlotDataStruct {
	struct IPDataStruct {
		bool IsHostname;
		char String[128];
	};
	struct SerialDataStruct {
		char Serial[41];
	};
	std::vector<ReservedSlotDataStruct::SerialDataStruct> SerialList;
	std::vector<ReservedSlotDataStruct::IPDataStruct> IPList;
	wchar_t Name[64];
	bool Banned, HasHostname, ReservedSlot, OneTime;
	unsigned long CreateTime;
};

// Queue structure
struct ReservedSlotQueueStruct {
	nc_cPacket *packet;
	char Hostname[128];
	int State;
	ReservedSlotDataStruct *Data;
	unsigned long CreateTime;
};

// Main class
class ReservedSlotClass {
	ncThread *HostnameThread;
	bool _SafeToDelete;
public:
	ReservedSlotClass();
	~ReservedSlotClass();
	void Add(ReservedSlotDataStruct *Data);
	void Add_Queue(nc_cPacket *, unsigned int DataIndex);
	bool Add_Temp(const wchar_t *Name);
	void Clear();
	bool Is_In_List(const wchar_t *Name);
	void Output();
	void Think();
	static void Load();
	static void __stdcall ResolveHostname();
	static void ReceiveSerial(const nc_cGameSpyCsChallengeResponseEvent *Response);
	int MaxPlayers;
	std::vector<ReservedSlotDataStruct> NickList;
	std::vector<ReservedSlotQueueStruct> QueueList;
};
extern ReservedSlotClass *ReservedSlot;

class ConsoleIO {
public:
	static void Input(const char *msg, ...);
	static void Output(const char *msg, ...);
};
extern ConsoleIO Console;

// Import load support
class Init_Class {
public:
	Init_Class();
	static void Init_Hook();
};
extern Init_Class InitClass;

extern bool Initialed;
void PatchData(void *buf, unsigned long size, unsigned long addr);
void PatchJump(void *buf, unsigned long addr);
void PatchCall(void *buf, unsigned long addr);
void PatchByte(unsigned char Byte, unsigned long size, unsigned long addr);
int __fastcall wildcmp(const char *wild, const char *string);
void DLL_Init();

#ifdef __DEV__
class ReservedSlotListConsoleCommand : public nc_ConsoleFunctionClass {
	const char *Get_Name()
	{
		return "rslist";
	}
	const char *Get_Alias()
	{
		return "rsl";
	}
	const char *Get_Help()
	{
		return "RSLIST - No info.";
	}
	void Activate(char *text)
	{
		ReservedSlot->Output();
	}
};
ReservedSlotListConsoleCommand *ReservedSlotList;
#endif

class ReloadReservedSlotConsoleCommand : public nc_ConsoleFunctionClass {
	const char *Get_Name()
	{
		return "reloadnicklist";
	}
	const char *Get_Alias()
	{
		return "reloadnl";
	}
	const char *Get_Help()
	{
		return "RELOADNICKLIST - Reload the reserved list from Nicks.cfg.";
	}
	void Activate(char *text)
	{
		ReservedSlotClass::Load();
		Console.Output("Reserved Slots list has been reloaded.\n");
	}
};
ReloadReservedSlotConsoleCommand *ReloadReservedSlot;

class AddTempReservedSlotConsoleCommand : public nc_ConsoleFunctionClass {
	const char *Get_Name()
	{
		return "addtempslot";
	}
	const char *Get_Alias()
	{
		return "ats";
	}
	const char *Get_Help()
	{
		return "ADDTEMPSLOT - Adds the nickname to temporary reserved slot.";
	}
	void Activate(char *text)
	{
		if (!text || !*text)
			return;
		wchar_t Name[64];
		mbstowcs(Name,text,sizeof(Name) -1);
		if (ReservedSlot->Add_Temp(Name))
			Console.Output("%.63S has been added to temporary reserved slot list.\n",Name);
		else
			Console.Output("%.63S is already in the reserved slot list.\n",Name);
	}
};
AddTempReservedSlotConsoleCommand *AddTempReservedSlot;

class MaxPlayersLimitConsoleCommand : public nc_ConsoleFunctionClass {
	const char *Get_Name()
	{
		return "plimit";
	}
	const char *Get_Help()
	{
		return "PLIMIT [0-127] - Set server max players from 0 to 127 instantly.";
	}
	void Activate(char *text)
	{
		if (!Initialed)
		{
			Console.Output("Failed to set max players. Error: 1\n");
			return;
		}
		if (!text || !*text || !isdigit(text[0]))
			return;

		int Max = atoi(text);
		if (Max > 127)
		{
			Console.Output("Invalid value: %d\n",Max);
			return;
		}
		cGame->MaxPlayers = Max;
		ReservedSlot->MaxPlayers = Max;
		PatchByte(0x90,8,0x477F4D);
		Console.Output("Max players limit has been set to %d.\n",Max);
	}
};
MaxPlayersLimitConsoleCommand *MaxPlayersLimit;

#endif
