#ifndef FDS_DEF
#define FDS_DEF

class SphereClass {
public:
	int unk1;
	int unk2;
	int unk3;
	float Diameter;
};

class Vector2 {
public:
	float X;
	float Y;
	Vector2(float NewX,float NewY)
	{
		X = NewX;
		Y = NewY;
	}
	Vector2()
	{
		X = 0;
		Y = 0;
	}
	Vector2 &operator-=(Vector2& v)
	{
		X = X - v.X;
		Y = Y - v.Y;
		return *this;
	}
};

struct Vector4 {
	float W;
	float X;
	float Y;
	float Z;
};

struct Matrix3D {
	Vector3 AxisX;
	float PosX;
	Vector3 AxisY;
	float PosY;
	Vector3 AxisZ;
	float PosZ;
};

class AABoxClass {
	Vector3 High;
	Vector3 Low;
};

struct Rotation {
	Vector3 AxisX;
	Vector3 AxisY;
	Vector3 AxisZ;
};

class OBBoxClass {
public:
	Rotation Rotation; //rotation matrix
	Vector3 Center; //centerpoint
	Vector3 Extent; //size (i.e. how far from the centerpoint in each direction does the box go)
};

struct RefStruct {
	int unknown;
	GameObject* obj;
};

class RectClass {
public:
	float Left;
	float Top;
	float Right;
	float Bottom;
	RectClass(float NewLeft,float NewTop,float NewRight,float NewBottom)
	{
		Left = NewLeft;
		Top = NewTop;
		Right = NewRight;
		Bottom = NewBottom;
	}
	RectClass()
	{
		Left = 0;
		Right = 0;
		Top = 0;
		Bottom = 0;
	}
	Vector2 Upper_Left()
	{
		return Vector2(Top,Left);
	}
	Vector2 Lower_Right()
	{
		return Vector2(Right,Bottom);
	}
	RectClass& operator*=(float f)
	{
		Left *= f;
		Right *= f;
		Top *= f;
		Bottom *= f;
		return *this;
	}
	RectClass& operator+=(class Vector2& v)
	{
		Left += v.X;
		Top += v.Y;
		Right += v.X;
		Bottom += v.Y;
		return *this;
	}
};

class PersistFactoryClass;
class PostLoadableClass {
	bool IsPostLoadRegistered;
public:
	virtual ~PostLoadableClass()
	{
	}
	virtual void On_Post_Load()
	{
	}
};

class PersistClass : public PostLoadableClass {
public:
	~PersistClass();
	virtual PersistFactoryClass &Get_Factory() = 0;
	virtual bool Save(ChunkSaveClass &csave);
	virtual bool Load(ChunkSaveClass &cload);
};

class ParameterClass;
class EditableClass : public PersistClass {
public:
	~EditableClass();
	virtual int Get_Parameter_Count();
	virtual ParameterClass *Lock_Parameter(int i);
	virtual void Unlock_Parameter(int i);
};

class DefinitionClass : public EditableClass {
	int m_DefinitionMgrLink;
	StringClass m_Name;
	unsigned long m_ID;
	unsigned long m_GenericUserData;
	bool m_SaveEnabled;
public:
	~DefinitionClass();
	bool Save(ChunkSaveClass &csave);
	bool Load(ChunkSaveClass &cload);
	virtual unsigned long Get_Class_ID() = 0;
	virtual unsigned long Get_ID();
	virtual void Set_ID(unsigned long id);
	virtual PersistClass *Create() = 0;
	virtual char *Get_Name();
	virtual void Set_Name(char *new_name);
	virtual bool Is_Valid_Config(const char *message);
};

class DefinitionMgrClass {
public:
	static DefinitionClass *Find_Definition(unsigned long ID, bool unk);
	static DefinitionClass *Find_Named_Definition(const char *name, bool unk);
	static DefinitionClass *Find_Typed_Definition(const char *name, unsigned long Type, bool unk);
	static DefinitionClass *Get_First(unsigned long Type, int unk);
	static DefinitionClass *Get_Next(DefinitionClass *Definition, unsigned long Type, int unk);
	static DefinitionClass *Get_Next(DefinitionClass *Definition);
};

class TeamPurchaseSettingsDefClass : public DefinitionClass {
public:
	unsigned int team;
	unsigned int presetids[4];
	unsigned int stringids[4];
	StringClass textures[4];
	unsigned int beaconcost;
	unsigned int beaconpresetid;
	unsigned int beaconstringid;
	StringClass beacontexture;
	unsigned int refillstringid;
	StringClass refilltexture;
	~TeamPurchaseSettingsDefClass();
	PersistFactoryClass &Get_Factory();
	bool Save(void *csave);
	bool Load(void *cload);
	unsigned long Get_Class_ID();
	virtual PersistClass *Create();
	static TeamPurchaseSettingsDefClass *Get_Definition(unsigned long team);
};

class PurchaseSettingsDefClass : public DefinitionClass {
public:
	unsigned int team;
	unsigned int type;
	unsigned int costs[10];
	unsigned int presetids[10];
	unsigned int stringids[10];
	StringClass textures[10];
	unsigned int altpresetids[10][3];
	StringClass alttextures[10][3];
	~PurchaseSettingsDefClass();
	PersistFactoryClass &Get_Factory();
	bool Save(ChunkSaveClass &csave);
	bool Load(ChunkSaveClass &cload);
	unsigned long Get_Class_ID();
	PersistClass *Create();
	static PurchaseSettingsDefClass *Find_Definition(unsigned long type, unsigned long team);
};

class FloatDataSafeClass {
	void *Data;
public:
	float Get();
	bool __stdcall Set(float &data);
	inline operator float() { return this->Get(); }
	void operator=(float value) { this->Set(value); }
	void operator+=(float value) {
		value = this->Get() + value;
		this->Set(value);
	}
	void operator-=(float value) {
		value = this->Get() - value;
		this->Set(value);
	}
	void operator*=(float value) {
		value = this->Get() * value;
		this->Set(value);
	}
	void operator/=(float value) {
		value = this->Get() / value;
		this->Set(value);
	}
};

class IntDataSafeClass {
	void *Data;
public:
	int Get();
	bool __stdcall Set(int &data);
	inline operator int() { return this->Get(); }
	void operator=(int value) { this->Set(value); }
	void operator+=(int value) {
		value = this->Get() + value;
		this->Set(value);
	}
	void operator-=(int value) {
		value = this->Get() - value;
		this->Set(value);
	}
	void operator*=(int value) {
		value = this->Get() * value;
		this->Set(value);
	}
	void operator/=(int value) {
		value = this->Get() / value;
		this->Set(value);
	}
};

class UIntDataSafeClass {
	void *Data;
public:
	unsigned int Get();
	bool __stdcall Set(unsigned int &data);
	inline operator unsigned int() { return this->Get(); }
	void operator=(unsigned int value) { this->Set(value); }
	void operator+=(unsigned int value) {
		value = this->Get() + value;
		this->Set(value);
	}
	void operator-=(unsigned int value) {
		value = this->Get() - value;
		this->Set(value);
	}
	void operator*=(unsigned int value) {
		value = this->Get() * value;
		this->Set(value);
	}
	void operator/=(unsigned int value) {
		value = this->Get() / value;
		this->Set(value);
	}
};

class ReferencerClass;
template <class T> class ReferenceableClass {
public:
	ReferencerClass *referencer;
	T *obj;
};

class ScriptableGameObj;
class ReferencerClass : public PostLoadableClass {
public:
	~ReferencerClass()
	{
	}
	void On_Post_Load()
	{
	}
	void __as(const ScriptableGameObj *);
	ReferenceableClass<ScriptableGameObj> *Reference;
	ReferencerClass *Next;
};

class ArmorWarheadManager {
public:
	static const char *Get_Warhead_Name(int Warhead);
	static float Get_Damage_Multiplier(unsigned int, unsigned int);
};

DefinitionClass *Get_Definition(GameObject *obj);
bool Is_Valid_Preset(const char *name);

#endif
