#ifndef FDS_OBJ
#define FDS_OBJ

// Forwarder
class AirStripGameObj;
class ArmedGameObj;
class BeaconGameObj;
class BuildingGameObj;
class C4GameObj;
class CinematicGameObj;
class ComCenterGameObj;
class DamageableGameObj;
class HarvesterClass;
class PhysicalGameObj;
class PowerUpGameObj;
class RefineryGameObj;
class RepairBayGameObj;
class ScriptZoneGameObj;
class SimpleGameObj;
class SmartGameObj;
class SoldierGameObj;
class VehicleGameObj;
class VehicleFactoryGameObj;
class WarFactoryGameObj;
class WeaponBagClass;
class RenderObjClass;

// Don't have
class AudibleSoundClass;
class AnimControlClass;
class PhysClass;
class ActiveConversationClass;
class SoundSceneObjClass;
class LogicalListenerClass;
class LogicalSoundClass;
class PersistantSurfaceEmitterClass;
class StaticPhysClass;
class BuildingAggregateClass;
class LightPhysClass;
class PersistantSurfaceSoundClass;
class SimpleAnimControlClass;
class HumanAnimControlClass;
class HumanPhysClass;
class CollisionEventClass;
class DynamicSpeechAnimClass;


class BaseGameObjDef : public DefinitionClass {
public:
	~BaseGameObjDef();
	bool Save(ChunkSaveClass &csave);
	bool Load(ChunkLoadClass &cload);
};

class BaseGameObj : public PersistClass, public NetworkObjectClass {
public:
	DefinitionClass *definition;
	bool ThinkTriggered;
	bool Freeze;
	~BaseGameObj();
	bool Save(ChunkSaveClass &csave);
	bool Load(ChunkLoadClass &cload);
	virtual void Init() = 0;
	virtual void Think();
	virtual void Post_Think();
	virtual bool Is_Hibernating();
	virtual PhysicalGameObj *As_PhysicalGameObj();
	virtual VehicleGameObj *As_VehicleGameObj();
	virtual SmartGameObj *As_SmartGameObj();
	virtual ScriptableGameObj *As_ScriptableGameObj();
	unsigned int Get_Network_Class_ID();
	void Delete();
};

class ScriptableGameObjDef : public BaseGameObjDef {
public:
	DynamicVectorClass<StringClass> Scripts;
	DynamicVectorClass<StringClass> Parameters;
	~ScriptableGameObjDef();
	bool Save(ChunkSaveClass &csave);
	bool Load(ChunkLoadClass &cload);
};

class AudioCallbackClass {
public:
	virtual ~AudioCallbackClass();
	virtual void On_Sound_Started(SoundSceneObjClass *);
	virtual void On_Sound_Ended(SoundSceneObjClass *);
	virtual void On_Logical_Heard(LogicalListenerClass *,LogicalSoundClass *);
	DynamicVectorClass<SoundSceneObjClass *> Sounds;
};

class GameObjObserverTimerClass {
	int ObserverID;
	float Time;
	int TimerNum;
};

class GameObjCustomTimerClass {
	float Delay;
	ReferencerClass Sender;
	int Message;
	int Param;
};

class ScriptableGameObj : public BaseGameObj, public ReferenceableClass<ScriptableGameObj>, public AudioCallbackClass {
public:
	~ScriptableGameObj();
	void On_Post_Load();
	bool Save(ChunkSaveClass &csave);
	bool Load(ChunkLoadClass &cload);
	void Think();
	void Post_Think();
	ScriptableGameObj *As_ScriptableGameObj();
	virtual void Post_Re_Init();
	void Set_Delete_Pending();
	virtual void Get_Position(Vector3 *Position) = 0;
	virtual DamageableGameObj *As_DamageableGameObj();
	virtual BuildingGameObj *As_BuildingGameObj();
	virtual SoldierGameObj *As_SoldierGameObj(); // 0x44
	virtual ScriptZoneGameObj *As_ScriptZoneGameObj();
	virtual void Get_Information(StringClass &str);
	virtual bool Is_Always_Dirty();
	void On_Sound_Ended(SoundSceneObjClass *);
	void Import_Creation(BitStreamClass &BitStream);
	void Export_Creation(BitStreamClass &BitStream);
	void Start_Observers();
	void Add_Observer(GameObjObserverClass *observ);
	void Remove_Observer(GameObjObserverClass *observ);
	bool ObserversNeedStarting;
	SimpleDynVecClass<GameObjObserverClass *> Observers;
	DynamicVectorClass<GameObjObserverTimerClass *> ObserverTimers;
	DynamicVectorClass<GameObjCustomTimerClass *> CustomTimers;
};

class ScriptZoneGameObj : public ScriptableGameObj {
public:
	~ScriptZoneGameObj();
	PersistFactoryClass &Get_Factory();
	bool Save(ChunkSaveClass &csave);
	bool Load(ChunkLoadClass &cload);
	void Init();
	void Think();
	void Get_Position(Vector3 *Position);
	ScriptZoneGameObj *As_ScriptZoneGameObj();
	bool Inside_Me(SmartGameObj *obj);
	OBBoxClass BoundingBox; // 0x72C
	int PlayerType;
	SList<ReferencerClass> ZoneContents;
};

class DefenseObjectDefClass {
	FloatDataSafeClass Health;
	FloatDataSafeClass HealthMax;
	UIntDataSafeClass Skin;
	FloatDataSafeClass ShieldStrength;
	FloatDataSafeClass ShieldStrengthMax;
	UIntDataSafeClass ShieldType;
	FloatDataSafeClass DamagePoints;
	FloatDataSafeClass DeathPoints;
};

class DamageableGameObjDef : public ScriptableGameObjDef {
public:
	~DamageableGameObjDef();
	bool Save(ChunkSaveClass &csave);
	bool Load(ChunkLoadClass &cload);
	DefenseObjectDefClass DefenseDef;
	StringClass InfoIconTextureFilename;
	unsigned int TranslatedNameID;
	int EncyclopediaType;
	unsigned int EncyclopediaID;
	bool NotTargetable; // 0x7C
	int PlayerType;
};

class OffenseObjectClass {
public:
	bool b1;
	bool b2;
	float damage;
	int warhead;
	ReferencerClass Damager;
};

class DefenseObjectClass {
public:
	virtual ~DefenseObjectClass();
	virtual void Import(BitStreamClass &BitStream);
	virtual void Export(BitStreamClass &BitStream);
	void Set_Max_Health(float health);
	void Set_Max_Shield_Strength(float shieldstrength);
	void Mark_Owner_Dirty();
	FloatDataSafeClass Health;
	FloatDataSafeClass HealthMax;
	UIntDataSafeClass Skin;
	FloatDataSafeClass ShieldStrength;
	FloatDataSafeClass ShieldStrengthMax;
	UIntDataSafeClass ShieldType;
	FloatDataSafeClass DamagePoints;
	FloatDataSafeClass DeathPoints;
	bool CanObjectDie;
	ReferencerClass Owner;
};

class DamageableGameObj : public ScriptableGameObj {
public:
	~DamageableGameObj();
	bool Save(ChunkSaveClass &csave);
	bool Load(ChunkLoadClass &cload);
	DamageableGameObj *As_DamageableGameObj();
	virtual void Apply_Damage(const OffenseObjectClass &offense,float f,int i);
	virtual void Completely_Damaged(const OffenseObjectClass &offense);
	virtual bool Is_Targetable();
	virtual bool Is_Health_Bar_Displayed();
	virtual void Set_Is_Health_Bar_Displayed(bool display);
	virtual int Get_Player_Type();
	virtual void Set_Player_Type(int type); // 0x6C
	void Import_Occasional(BitStreamClass &BitStream);
	void Export_Occasional(BitStreamClass &BitStream);
	Vector3 Get_Team_Color();
	bool Is_Enemy(GameObject *obj);
	DefenseObjectClass Defense; // 0x72C
	int PlayerType; // 0x764
	bool IsHealthBarDisplayed; // 0x768
};

class PhysicalGameObjDef : public DamageableGameObjDef {
public:
	~PhysicalGameObjDef();
	bool Save(ChunkSaveClass &csave);
	bool Load(ChunkLoadClass &cload);
	bool Is_Valid_Config(const char *message);
	int Type;
	int BlipShape;
	float BullseyeOffsetZ;
	StringClass Animation;
	int PhysDefID;
	int KilledExplosionID;
	bool DefaultHibernationEnable;
	bool AreInnateConversationsAllowed;
	int OratorType;
	bool UseCreationEffect;
};

class PhysObserverClass {
public:
	virtual int Collision_Occurred(const CollisionEventClass& collide);
	virtual int Object_Expired(PhysClass *obj);
	virtual void Object_Removed_From_Scene(PhysClass *obj);
	virtual void Object_Shattered_Something(PhysClass *obj1,PhysClass *obj2,int i);
};

class CombatPhysObserverClass : public PhysObserverClass {
public:
	virtual DamageableGameObj *As_DamageableGameObj();
	virtual BuildingGameObj *As_BuildingGameObj();
	virtual PhysicalGameObj *As_PhysicalGameObj();
};

class PhysicalGameObj : public DamageableGameObj, public CombatPhysObserverClass {
public:
	~PhysicalGameObj();
	void On_Post_Load();
	bool Save(ChunkSaveClass &csave);
	bool Load(ChunkLoadClass &cload);
	void Post_Think();
	bool Is_Hibernating();
	PhysicalGameObj *As_PhysicalGameObj();
	VehicleGameObj *As_VehicleGameObj();
	void Get_Position(Vector3 *Position); // 0x38
	DamageableGameObj *As_DamageableGameObj();
	SoldierGameObj *As_SoldierGameObj();
	void Get_Information(StringClass &str);
	void Export_Creation(BitStreamClass &BitStream);
	void Import_Creation(BitStreamClass &BitStream);
	void Apply_Damage(const OffenseObjectClass &offense,float f,int i);
	void Completely_Damaged(const OffenseObjectClass &offense);
	void Set_Player_Type(int type);
	virtual void Startup();
	virtual void Set_Animation(const char *animation,bool loop,float firstframe);
	virtual void Set_Animation_Frame(const char *animation,int frame);
	virtual float Get_Bullseye_Position();
	virtual void Apply_Damage_Extended(const OffenseObjectClass &offense,float f,const Vector3& v,int i); // 0x80
	virtual bool Takes_Explosion_Damage();
	int Object_Expired(PhysClass *obj);
	virtual PowerUpGameObj *As_PowerUpGameObj();
	virtual C4GameObj *As_C4GameObj();
	virtual BeaconGameObj *As_BeaconGameObj();
	virtual ArmedGameObj *As_ArmedGameObj();
	virtual CinematicGameObj *As_CinematicGameObj();
	virtual SimpleGameObj *As_SimpleGameObj();
	virtual void Begin_Hibernation();
	virtual void End_Hibernation();
	void Export_Rare(BitStreamClass &BitStream);
	void Import_Rare(BitStreamClass &BitStream);
	void Export_Frequent(BitStreamClass &BitStream);
	void Import_Frequent(BitStreamClass &BitStream);
	int Get_Vis_ID();
	bool Get_World_Position(Vector3 &Position);
	void Object_Shattered_Something(PhysClass *obj1,PhysClass *obj2,int i);
	void Set_Transform(Matrix3D *mat);
	Matrix3D *Get_Transform();
	ActiveConversationClass *Conversation;
	PhysClass *Physics; // 0x774
	AnimControlClass *Animation;
	int ServerSkips;
	float HibernationTime;
	bool IsHibernating;
	ReferencerClass Ref;
	int AttachBoneIndex;
	int RadarBlipShape;
	int RadarBlipColor;
	float RadarBlipIntensity;
	PhysicalGameObj *AttachObj;
	bool HudPokableIndicatorEnabled;
	bool InnateConversationsEnabled;
};

class SpecialEffectsGameObjDef : public PhysicalGameObjDef {
public:
	~SpecialEffectsGameObjDef();
	PersistFactoryClass &Get_Factory();
	bool Save(ChunkSaveClass &csave);
	bool Load(ChunkLoadClass &cload);
	unsigned long Get_Class_ID();
	PersistClass *Create();
	StringClass AnimationName;
	int SoundDefID;
};

class SpecialEffectsGameObj : public PhysicalGameObj {
public:
	~SpecialEffectsGameObj();
	PersistFactoryClass &Get_Factory();
	bool Save(ChunkSaveClass &csave);
	bool Load(ChunkLoadClass &cload);
	void Init();
	void Think();
	float TotalTime;
	bool EffectRunning;
};

class SimpleGameObjDef : public PhysicalGameObjDef {
public:
	~SimpleGameObjDef();
	PersistFactoryClass &Get_Factory();
	bool Save(ChunkSaveClass &csave);
	bool Load(ChunkLoadClass &cload);
	unsigned long Get_Class_ID();
	PersistClass *Create();
	bool IsEditorObject;
	bool IsHiddenObject;
	int PlayerTerminalType;
};

class SimpleGameObj : public PhysicalGameObj {
public:
	~SimpleGameObj();
	void On_Post_Load();
	PersistFactoryClass &Get_Factory();
	bool Save(ChunkSaveClass &csave);
	bool Load(ChunkLoadClass &cload);
	void Init();
	bool Is_Always_Dirty();
	SimpleGameObj *As_SimpleGameObj();
};

class PowerUpGameObjDef : public SimpleGameObjDef {
public:
	~PowerUpGameObjDef();
	PersistFactoryClass &Get_Factory();
	bool Save(ChunkSaveClass &csave);
	bool Load(ChunkLoadClass &cload);
	unsigned long Get_Class_ID();
	PersistClass *Create();
	int GrantShieldType;
	float GrantShieldStrength;
	float GrantShieldStrengthMax;
	float GrantHealth;
	float GrantHealthMax;
	int GrantWeaponID;
	bool GrantWeapon;
	int GrantWeaponRounds;
	bool GrantWeaponClips;
	bool Persistant;
	int GrantKey;
	bool AlwaysAllowGrant;
	int GrantSoundID;
	StringClass GrantAnimationName;
	int IdleSoundID;
	StringClass IdleAnimationName;
	void Grant(GameObject *obj,int powerup,bool showonhud);
};

class PowerUpGameObj : public SimpleGameObj {
public:
	~PowerUpGameObj();
	void On_Post_Load();
	PersistFactoryClass &Get_Factory();
	bool Save(ChunkSaveClass &csave);
	bool Load(ChunkLoadClass &cload);
	void Init();
	void Think();
	bool Is_Always_Dirty();
	PowerUpGameObj *As_PowerUpGameObj();
	void Get_Description(StringClass &Description);
	AudibleSoundClass *IdleSound;
	int State;
	float Time;
	WeaponBagClass *Backpack;

	void Grant(GameObject *obj);
};

class MuzzleRecoilClass {
public:
	int unk1;
	float unk2;
	float unk3;
	float unk4;
};

class ArmedGameObjDef : public PhysicalGameObjDef {
public:
	~ArmedGameObjDef();
	bool Save(ChunkSaveClass &csave);
	bool Load(ChunkLoadClass &cload);
	//All of these floats are in radians (although leveledit shows degrees)
	float WeaponTiltRate; // 0xA8
	float WeaponTiltMin; // 0xAC
	float WeaponTiltMax; // 0xB0
	float WeaponTurnRate; // 0xB4
	float WeaponTurnMin; // 0xB8
	float WeaponTurnMax; // 0xBC
	float WeaponError; // 0xC0
	int WeaponDefID; // 0xC4
	int SeconaryWeaponDefID; // 0xC8
	int WeaponRounds; // 0xCC
};

class ArmedGameObj : public PhysicalGameObj {
public:
	~ArmedGameObj();
	void On_Post_Load();
	bool Save(ChunkSaveClass &csave);
	bool Load(ChunkLoadClass &cload);
	void Post_Think();
	bool Is_Always_Dirty();
	ArmedGameObj *As_ArmedGameObj();
	void Export_Frequent(BitStreamClass &BitStream);
	void Import_Frequent(BitStreamClass &BitStream);
	virtual void Import_State_Cs(BitStreamClass &BitStream);
	virtual void Export_State_Cs(BitStreamClass &BitStream);
	virtual Matrix3D Get_Muzzle(int muzzle);
	virtual bool Set_Targeting(const Vector3& target, bool b);
	ArmedGameObjDef *Get_Definition();
	WeaponBagClass *WeaponBag;
	Vector3 TargetVector;
	int MuzzleBoneIndexes[4];
	MuzzleRecoilClass MuzzleRecoils[4];
};

class CinematicGameObjDef : public ArmedGameObjDef {
public:
	~CinematicGameObjDef();
	PersistFactoryClass &Get_Factory();
	bool Save(ChunkSaveClass &csave);
	bool Load(ChunkLoadClass &cload);
	unsigned long Get_Class_ID();
	PersistClass *Create();
	int SoundDefID;
	StringClass SoundBoneName;
	StringClass AnimationName;
	bool AutoFireWeapon;
	bool DestroyAfterAnimation;
	bool CameraRelative;
};

class CinematicGameObj : public ArmedGameObj {
public:
	~CinematicGameObj();
	void On_Post_Load();
	PersistFactoryClass &Get_Factory();
	bool Save(ChunkSaveClass &csave);
	bool Load(ChunkLoadClass &cload);
	void Init();
	void Think();
	void Post_Think();
	void Completely_Damaged(const OffenseObjectClass &offense);
	bool Takes_Explosion_Damage();
	CinematicGameObj *As_CinematicGameObj();
	void Export_Rare(BitStreamClass &BitStream);
	void Import_Rare(BitStreamClass &BitStream);
	AudibleSoundClass *Sound;
};

class BuildingMonitorClass : public GameObjObserverClass {
public:
	virtual ~BuildingMonitorClass();
	virtual char *Get_Name();
	virtual void Attach(GameObject *newobj);
	virtual void Detach(GameObject *obj);
	virtual void Created(GameObject *obj);
	virtual void Destroyed(GameObject *obj);
	virtual void Killed(GameObject *obj,GameObject *shooter) ;
	virtual void Damaged(GameObject *obj,GameObject *damager,float damage);
	virtual void Custom(GameObject *obj,int message,int param,GameObject *sender);
	virtual void Sound_Heard(GameObject *obj,const CombatSound & sound);
	virtual void Enemy_Seen(GameObject *obj,GameObject *seen);
	virtual void Action_Complete(GameObject *obj,int action,ActionCompleteReason reason);
	virtual void Timer_Expired(GameObject *obj,int number);
	virtual void Animation_Complete(GameObject *obj,const char *anim);
	virtual void Poked(GameObject *obj,GameObject *poker);
	virtual void Entered(GameObject *obj,GameObject *enter);
	virtual void Exited(GameObject *obj,GameObject *exit);
	BuildingGameObj *Building;
};

class BuildingGameObjDef : public DamageableGameObjDef {
public:
	~BuildingGameObjDef();
	PersistFactoryClass &Get_Factory();
	bool Save(ChunkSaveClass &);
	bool Load(ChunkLoadClass &);
	unsigned long Get_Class_ID();
	PersistClass *Create();
	StringClass MeshPrefix; // 0x84
	int MCTSkin; // 0x88
	int Type; // 0x8C
	int GDIDamageReportID; // 0x90
	int NodDamageReportID; // 0x94
	int GDIDestroyReportID; // 0x98
	int NodDestroyReportID; // 0x9C
};

class BuildingGameObj : public DamageableGameObj, public CombatPhysObserverClass {
public:
	~BuildingGameObj();
	virtual PersistFactoryClass &Get_Factory();
	bool Save(ChunkSaveClass &);
	bool Load(ChunkLoadClass &);
	void Init();
	void Get_Position(Vector3 *);
	virtual DamageableGameObj *As_DamageableGameObj();
	BuildingGameObj *As_BuildingGameObj();
	void Export_Creation(BitStreamClass &);
	void Import_Creation(BitStreamClass &);
	void Apply_Damage(OffenseObjectClass const &,float,int);
	virtual void As_PowerPlantGameObj(); // 0x70
	virtual void As_SoldierFactoryGameObj(); // 0x74
	virtual VehicleFactoryGameObj *As_VehicleFactoryGameObj(); // 0x78
	virtual AirStripGameObj *As_AirStripGameObj(); // 0x7C
	virtual WarFactoryGameObj *As_WarFactoryGameObj(); // 0x80
	virtual RefineryGameObj *As_RefineryGameObj(); // 0x84
	virtual ComCenterGameObj *As_ComCenterGameObj(); // 0x88
	virtual RepairBayGameObj *As_RepairBayGameObj(); // 0x8C
	virtual void CnC_Initialize(BaseControllerClass *);
	virtual void On_Destroyed();
	virtual void On_Damaged();
	void Import_Rare(BitStreamClass &);
	void Export_Rare(BitStreamClass &);
	bool Get_World_Position(Vector3 &);
	void Get_Description(StringClass &);
	bool Is_Tagged();
	BuildingMonitorClass *Monitor; // 0x770
	BaseControllerClass *Base; // 0x774
	bool Destroyed; // 0x778
	Vector3 Position; // 0x77C
	bool Is_Powered; // 0x788
	int State; // 0x78C
	AudibleSoundClass *Audio; // 0x790
	int unkb1; // 0x794
	int unkb2; // 0x798
	int unkb3; // 0x79C
	float unkb4; // 0x7A0
	SphereClass Sphere; // 0x7A4
	RefMultiListClass<StaticPhysClass> Phys1; // 0x7B4
	RefMultiListClass<StaticPhysClass> Phys2; // 0x7CC
	RefMultiListClass<BuildingAggregateClass> Aggregate; // 0x7E4
	RefMultiListClass<LightPhysClass> Light1; // 0x7FC
	RefMultiListClass<LightPhysClass> Light2; // 0x814
};

class RefineryGameObjDef : public BuildingGameObjDef {
public:
	~RefineryGameObjDef();
	PersistFactoryClass &Get_Factory();
	bool Save(ChunkSaveClass &);
	bool Load(ChunkLoadClass &);
	unsigned long Get_Class_ID();
	PersistClass *Create();
	float UnloadTime; // 0xA0
	float FundsGathered; // 0xA4
	float FundsDistribedPerSec; // 0xA8
	unsigned int Harvester; // 0xAC
};
class RefineryGameObj : public BuildingGameObj {
public:
	RefineryGameObjDef *Get_Definition();
	void On_Harvester_Docked();
	void Set_Harvester_Vehicle(VehicleGameObj *obj);
	GameObject *Get_Harvester_Vehicle();
	HarvesterClass *Harvester; // 0x82C
	OBBoxClass DumpZone; // 0x830 (0x3C)
	bool IsHarvesterDocked; // 0x86C
	float UnloadTimeCounter; // 0x870
	int SceneObjectID; // 0x874
	float PoolMoney; // 0x878
	float unkr3; // 0x87C
	float TickCounter; // 0x880
};

class SoldierFactoryGameObjDef : public BuildingGameObjDef {
public:
	// No variable
};
class SoldierFactoryGameObj : public BuildingGameObj {
public:
	// No variable
};

class VehicleFactoryGameObjDef : public BuildingGameObjDef {
public:
	int PadClearingWarhead; // 0xA0
	float BuildTime; // 0xA4
};
class VehicleFactoryGameObj : public BuildingGameObj {
public:
	int Get_Team_Vehicle_Count();
	void Request_Vehicle(int PresetID, float Delay, GameObject *Owner);
	static int &MaxVehiclesPerTeam;
	ReferencerClass GeneratedVehicle; // 0x82C
	Matrix3D Creation_TM; // 0x83C
	OBBoxClass ConstructionZone; // 0x86C
	float GenerateDelay; // 0x8A8
	int ProcessingPresetID; // 0x8AC
	bool IsGenerating; // 0x8B0
	ReferencerClass Purchaser; // 0x8B4
	bool unkvf1; // 0x8B8
	ReferencerClass *Cinematic; // 0x8BC
	int unkvf3; // 0x8C0
	bool IsBusy; // 0x8C4
	float BuildTimeCounter; // 0x8C8
};

class WarFactoryGameObjDef : public VehicleFactoryGameObjDef {
public:
	// No variable
};
class WarFactoryGameObj : public VehicleFactoryGameObj {
public:
	int SceneObjectID; // 0x8CC
	int Unitialized_Timer; // 0x8D0
};

class AirStripGameObjDef : public VehicleFactoryGameObjDef {
public:
	float CinematicLengthToVehicleDisplay; // 0xA8
	int CinematicSlotIndex; // 0xAC
	float CinematicLengthToDropOff; // 0xB0
	unsigned long DropOffCinematic; // 0xB4
};
class AirStripGameObj : public VehicleFactoryGameObj {
public:
	float CinematicLiveCounter; // 0x8CC
	int unkas2; // 0x8D0
	float VehicleDropOffCounter; // 0x8D4
	float CinematicDropOffCounter; // 0x8D8
	bool Cinematic_Available; // 0x8DC
	VehicleGameObj *AnimVehicle; // 0x8E0
};

class PowerPlantGameObjDef : public BuildingGameObjDef {
public:
	// No variable
};
class PowerPlantGameObj : public BuildingGameObj {
public:
	// No variable
};

class RepairBayGameObjDef : public BuildingGameObjDef {
public:
	float RepairPerSec; // 0xA0
	unsigned long RepairingStaticAnimType; // 0xA4
};
class RepairBayGameObj : public BuildingGameObj {
public:
	float RepairTimer; // 0x82C
	OBBoxClass RepairZone; // 0x830
	int SceneObjectId; // 0x86C
	bool Effect_Enable; // 0x870
	DynamicVectorClass<ReferencerClass> Vehicles; // 0x874
	BuildingAggregateClass *Aggregate; // 0x88C
	CinematicGameObj *Cinematic; // 0x890
};

class ComCenterGameObjDef : public BuildingGameObjDef {
public:
	// No variable
};
class ComCenterGameObj : public BuildingGameObj {
public:
	// No variable
};

class HarvesterClass : public GameObjObserverClass {
public:
	virtual ~HarvesterClass();
	virtual char *Get_Name();
	virtual void Attach(GameObject *newobj);
	virtual void Detach(GameObject *obj);
	virtual void Created(GameObject *obj);
	virtual void Destroyed(GameObject *obj);
	virtual void Killed(GameObject *obj,GameObject *shooter) ;
	virtual void Damaged(GameObject *obj,GameObject *damager,float damage);
	virtual void Custom(GameObject *obj,int message,int param,GameObject *sender);
	virtual void Sound_Heard(GameObject *obj,const CombatSound & sound);
	virtual void Enemy_Seen(GameObject *obj,GameObject *seen);
	virtual void Action_Complete(GameObject *obj,int action,ActionCompleteReason reason);
	virtual void Timer_Expired(GameObject *obj,int number);
	virtual void Animation_Complete(GameObject *obj,const char *anim);
	virtual void Poked(GameObject *obj,GameObject *poker);
	virtual void Entered(GameObject *obj,GameObject *enter);
	virtual void Exited(GameObject *obj,GameObject *exit);
	void Go_Harvest(void);
	RefineryGameObj *Refinery; // 0x8
	Vector3 Dock_Location; // 0xC
	Vector3 Dock_Entrance; // 0x18
	int State; // 0x24
	OBBoxClass Tiberium_Region; // 0x28
	VehicleGameObj *Vehicle; // 0x64
	StringClass HarvestAnim; // 0x68
	float EachHarvestTimeCounter; // 0x6C
	float HarvestTimeCounter; // 0x70
};

class ControlClass {
public:
	enum BooleanControl {
		JUMP = 0,
		WEAPON_SELECT_NEXT = 1,
		WEAPON_SELECT_PREV = 2,
		DETONATE_C4 = 4,
		DIVE = 6,
		TRANSITION = 9,
		PRIMARY_FIRE = 23,
		SECONDARY_FIRE = 24,
		WALKING = 25,
	};
	bool var0; // 0x0
	int var4; // 0x4
	unsigned char State; // 0x8
	float WalkDirectionX; // 0xC
	float WalkDirectionY; // 0x10
	float var14; // 0x14
	float var18; // 0x18
};

class ActionClass;
class ActionCodeClass : public PersistClass {
public:
	virtual ~ActionCodeClass();
	bool Save(ChunkSaveClass &);
	bool Load(ChunkSaveClass &);
	void Init(ActionClass *);
	void Modify_Parameters(const void *SafeActionParamsStruct, bool, bool);
	void Set_Action(ActionClass *);
	void Shutdown();
	int Act();
	bool Is_Animating();
	bool Is_Busy();
	void Begin_Hibernation();
	void End_Hibernation();
	ActionClass *Action; // 0x8
};

class ActionClass {
public:
	virtual ~ActionClass();
	SmartGameObj *Owner; // 0x4
	ActionCodeClass *ActionCode; // 0x8
	ActionParamsStruct ActionParams; // 0xC
	ReferencerClass unkac2; // 0xD0
	ReferencerClass unkac3; // 0xE0
	ReferencerClass unkac4; // 0xF0
	StringClass unkac5; // 0x100
	StringClass unkac6; // 0x104
	bool IsPaused; // 0x108
	int ActCount; // 0x10C
};

class MaterialEffectClass : public MultiListObjectClass, public RefCountClass {
public:
	bool EnableAutoRemove; // 0x10
	bool EnableSuppressShadows; // 0x11
};

class StealthEffectClass {
public:
	~StealthEffectClass();
	bool EnableStealth; // 0x14
	bool IsFriendly; // 0x15
	bool IsBroken; // 0x16
	float FadeDistance; // 0x1C
	float State; // 0x20
	float TargetState; // 0x24
};

class SmartGameObjDef : public ArmedGameObjDef {
public:
	~SmartGameObjDef();
	bool Save(ChunkSaveClass &);
	bool Load(ChunkSaveClass &);
	float SightRange; // 0xD0
	float SightArc; // 0xD4
	float Listener_Scale; // 0xD8
	bool IsStealthUnit; // 0xDC
};

class SmartGameObj : public ArmedGameObj {
public:
	~SmartGameObj();
	virtual void On_Post_Load();
	bool Save(ChunkSaveClass &);
	bool Load(ChunkLoadClass &);
	virtual void Think();
	virtual void Post_Think();
	SmartGameObj *As_SmartGameObj(); // 0x6C
	virtual void Get_Information(StringClass &);
	void Export_Creation(BitStreamClass &);
	void Import_Creation(BitStreamClass &);
	virtual void Apply_Damage(const OffenseObjectClass &, float, int);
	virtual void Begin_Hibernation();
	virtual void End_Hibernation();
	void Export_Frequent(BitStreamClass &);
	void Import_Frequent(BitStreamClass &);
	virtual void Import_State_Cs(BitStreamClass &);
	virtual void Export_State_Cs(BitStreamClass &);
	virtual void Generate_Control();
	virtual SoldierGameObj *Get_Weapon_Control_Owner();
	virtual void Set_Control_Owner(int); // 0xC0
	virtual void Apply_Control();
	virtual float Get_Max_Speed();
	virtual float Get_Turn_Rate();
	virtual Matrix3D *Get_Look_Transform();
	virtual void Get_Velocity(Vector3 &);
	virtual bool Is_Visible(); // 0xD8
	virtual void On_Logical_Heard(LogicalListenerClass *, LogicalSoundClass *);
	virtual float Get_Stealth_Fade_Distance(); // 0xDC
	ControlClass Control; // 0x810
	float var82C; // 0x82C
	float var830; // 0x830
	float JumpVelocity; // 0x834
	float var838; // 0x838
	bool Control_Enable; // 0x83C
	bool Enable_Stealth; // 0x83D
	float StealthPowerupEffectCounter; // 0x840
	float var884; // 0x844
	StealthEffectClass *StealthEffect; // 0x848
	ActionClass Action; // 0x84C (0x110)
	int ControlOwner; // 0x95C
	cPlayer *Player; // 0x960
	bool CanEnemySee; // 0x964
	float CheckVisibleTimer; // 0x968
	LogicalListenerClass *LogicalListener; // 0x96C
};

class HumanStateClass {
public:
	typedef enum {
		Upright = 0,
		LAND = 1,
		ANIMATION = 2,
		WOUND = 3,
		LOITER = 4,
		AIRBRONE = 5,
		DIVE = 6,
		DEATH = 7,
		LADDER = 8,
		IN_VEHICLE = 9,
		TRANSITON = 10,
		TRANSITION_COMPLETE = 11,
		DESTROY = 12,
		DEBUG_FLY = 13,
		ON_FIRE = 14,
		ON_CHEM = 15,
		ON_ELECTRIC = 16,
		ON_CNC_FIRE = 17,
		ON_CNC_CHEM = 18,
		LOCKED_AMINATION = 19,
	} HumanStateType;
	typedef enum {
		NORMAL = 0,
		CROUCH = 1,
		SNIPING = 2,
		CROUCH_SNIPING = 3,
	} HumanActionType;
	bool State_Locked; // 0x0
	HumanStateType State; // 0x4
	int var8; // 0x8
	HumanActionType ActionType; // 0xC
	int SubState; // 0x10
	int AnimationType; // 0x14
	float AnimationCounter; // 0x18
	bool Loiters_Allowed; // 0x1C
	float Loiter_Delay; // 0x20
	float Aim1; // 0x24
	float Aim2; // 0x28
	HumanPhysClass *HumanPhys; // 0x2C
	HumanAnimControlClass *AnimControl; // 0x30
	int var34; // 0x34
	int var38; // 0x38
	Matrix3D JumpStart; // 0x3C
	float var6C; // 0x6C
	float var70; // 0x70
	bool var74; // 0x74
	bool var75; // 0x75
	DefinitionClass *AnimOverride; // 0x78
	DefinitionClass *LoiterCollection; // 0x7C
};

class DialogueOptionClass {
public:
	~DialogueOptionClass();
	float Weight;
	int ConversationID;
};

class DialogueClass {
public:
	~DialogueClass();
	float Weight; // 0x0
	DynamicVectorClass<DialogueOptionClass *> Vector; // 0x4
	float Silence_Weight; // 0x1C
};

class PersistentGameObjObserverClass : public PersistClass, public GameObjObserverClass {
public:
	~PersistentGameObjObserverClass();
};

class SoldierObserverClass : public PersistentGameObjObserverClass {
public:
	virtual ~SoldierObserverClass();
	virtual char *Get_Name();
	virtual void Attach(GameObject *newobj);
	virtual void Detach(GameObject *obj);
	virtual void Created(GameObject *obj);
	virtual void Destroyed(GameObject *obj);
	virtual void Killed(GameObject *obj,GameObject *shooter) ;
	virtual void Damaged(GameObject *obj,GameObject *damager,float damage);
	virtual void Custom(GameObject *obj,int message,int param,GameObject *sender);
	virtual void Sound_Heard(GameObject *obj,const CombatSound & sound);
	virtual void Enemy_Seen(GameObject *obj,GameObject *seen);
	virtual void Action_Complete(GameObject *obj,int action,ActionCompleteReason reason);
	virtual void Timer_Expired(GameObject *obj,int number);
	virtual void Animation_Complete(GameObject *obj,const char *anim);
	virtual void Poked(GameObject *obj,GameObject *poker);
	virtual void Entered(GameObject *obj,GameObject *enter);
	virtual void Exited(GameObject *obj,GameObject *exit);
	int unk; // 0x10
	int unk2; // 0x14
	Vector3 HomePosition; // 0x18
	float Facing; // 0x24
};

class SoldierGameObjDef : public SmartGameObjDef {
public:
	~SoldierGameObjDef();
	PersistFactoryClass &Get_Factory();
	bool Save(ChunkSaveClass &);
	bool Load(ChunkLoadClass &);
	unsigned long Get_Class_ID();
	PersistClass *Create();
	float TurnRate; // 0xE0
	float JumpVelocity; // 0xE4
	float SkeletonHeight; // 0xE8
	float SkeletonWidth; // 0xEC
	bool UseInnateBehavior; // 0xF0
	float InnateAggressiveness; // 0xF4
	float InnateTakeCoverProbability; // 0xF8
	bool InnateIsStationary; // 0xFC
	DialogueClass Dialog[20]; // 0x100
	StringClass FirstPersonHands; // 0x380
	unsigned int HumanAnimOverrideDefID; // 0x384
	unsigned int HumanLoiterCollectionDefID; // 0x388
	unsigned int DeathSoundPresetID; // 0x38C
};
class SoldierGameObj : public SmartGameObj {
public:
	~SoldierGameObj();
	virtual void On_Post_Load();
	virtual PersistFactoryClass &Get_Factory();
	bool Save(ChunkSaveClass &);
	bool Load(ChunkLoadClass &);
	virtual void Init();
	virtual void Think();
	virtual void Post_Think();
	SoldierGameObj *As_SoldierGameObj();
	virtual void Get_Information(StringClass &);
	void Export_Creation(BitStreamClass &);
	void Import_Creation(BitStreamClass &);
	virtual void Apply_Damage(const OffenseObjectClass &, float, int);
	virtual void Completely_Damaged(const OffenseObjectClass &);
	virtual bool Is_Targetable();
	void Import_Occasional(BitStreamClass &);
	void Export_Occasional(BitStreamClass &);
	virtual void Set_Animation(const char *, bool, float);
	virtual float Get_Bullseye_Position();
	virtual void Apply_Damage_Extended(const OffenseObjectClass &, float, const Vector3 &, int);
	void Export_Rare(BitStreamClass &);
	void Import_Rare(BitStreamClass &);
	void Export_Frequent(BitStreamClass &);
	void Import_Frequent(BitStreamClass &);
	virtual void Import_State_Cs(BitStreamClass &);
	virtual void Export_State_Cs(BitStreamClass &);
	virtual Matrix3D Get_Muzzle(int);
	virtual bool Set_Targeting(const Vector3 &, bool);
	virtual void Set_Control_Owner(int);
	virtual void Apply_Control();
	virtual float Get_Max_Speed(); // 0xC8
	virtual float Get_Turn_Rate();
	virtual Matrix3D *Get_Look_Transform();
	virtual void Get_Velocity(Vector3 &);
	virtual bool Is_Visible();
	virtual float Get_Stealth_Fade_Distance(); // 0xDC
	int Collision_Occurred(const CollisionEventClass &);
	virtual bool Is_Turreted(); // 0xE0
	virtual void Set_Weapon_Model(const char *);
	virtual void Set_Weapon_Animation(const char *);
	virtual void Start_Transition_Animation(const char *, TransitionCompletionDataStruct *);
	virtual void Set_Blended_Animation(const char *, bool, float, bool);
	void Get_Description(StringClass &);
	virtual void Set_Max_Speed(float);
	virtual bool Wants_Powerups();
	virtual bool Allow_Special_Damage_State_Lock();
	void Re_Init(SoldierGameObjDef &def);
	void Give_All_Weapons();
	void Toggle_Fly_Mode();
	RenderObjClass *CurrentWeaponRender; // 0x970
	RenderObjClass *BackWeaponRender; // 0x974
	RenderObjClass *BackFlagRender; // 0x978
	SimpleAnimControlClass *WeaponAnim; // 0x97C
	StringClass Animation; // 0x980
	TransitionCompletionDataStruct *TransitionCompleteData; // 0x984
	StringClass StateName; // 0x988
	VehicleGameObj *Vehicle; // 0x98C
	HumanStateClass Human; // 0x990 (0x80)
	int varA10; // 0xA10
	bool varA14; // 0xA14
	bool CanHandleLegs; // 0xA15
	int KeyLevel; // 0xA18
	int varA1C; // 0xA1C
	DialogueClass Dialogue[20]; // 0xA20
	int varCA0; // 0xCA0
	float Facing; // 0xCA4
	Vector3 unks9; // 0xCA8
	Vector3 LockedSoldierFacing; // 0xCB4
	Vector3 unks11; // 0xCC0
	int varCCC; // 0xCCC
	int SpecialDamageType; // 0xCD0
	float SpecialDamageDurationCounter; // 0xCD4
	ReferencerClass unks15; // 0xCD8
	int varCE8; // 0xCE8
	int varCEC; // 0xCEC
	ReferencerClass LockedToSoldier; // 0xCF0
	bool LockFacing; // 0xD00
	int Innate_State; // 0xD04
	SoldierObserverClass *Observer; // 0xD08
	int AI_State; // 0xD0C
	DynamicSpeechAnimClass *SpeechAnim; // 0xD10
	float ConversationCounter; // 0xD14
	StringClass HeadModel; // 0xD18;
	RefCountClass *RefCount; // 0xD1C
	float EmotIconLiveCounter; // 0xD20
	bool IsFlying; // 0xD24
	bool IsVisible; // 0xD25
	bool Ladder1; // 0xD26
	bool Ladder2; // 0xD27
	float varD28; // 0xD28
	bool AllowWeaponChange; // 0xD2C
	PersistantSurfaceEmitterClass *SurfaceEmitter; // 0xD30
	DynamicVectorClass<RenderObjClass *> VehicleRenderList; // 0xD34
};

class VehicleGameObjDef : public SmartGameObjDef {
public:
	~VehicleGameObjDef();
	PersistFactoryClass &Get_Factory();
	bool Save(ChunkSaveClass &);
	bool Load(ChunkLoadClass &);
	unsigned long Get_Class_ID();
	PersistClass *Create();
	int VehicleType; // 0xE0
	StringClass TypeName; // 0xE4
	StringClass Fire0Anim; // 0xE8
	StringClass Fire1Anim; // 0xEC
	StringClass Profile; // 0xF0
	DynamicVectorClass<TransitionDataClass *> TransitionList; // 0xF4
	float Turn_Radius; // 0x10C
	bool OccupantsVisible; // 0x110
	bool SightDownMuzzle; // 0x111
	bool Aim2D; // 0x112
	float EngineSoundMaxPitchFactor; // 0x114
	unsigned int EngineStartSound; // 0x118
	unsigned int EngineRunningLoop; // 0x11C
	unsigned int EngineStopSound; // 0x120
	float unkvd; // 0x124
	float SquishVelocity; // 0x128
	unsigned int VehicleName; // 0x12C
	int NumSeats; // 0x130
	unsigned int GDIDamageReportID; // 0x134
	unsigned int NodDamageReportID; // 0x138
	unsigned int GDIDestroyReportID; // 0x13C
	unsigned int NodDestroyReportID; // 0x140
};
class VehicleGameObj : public SmartGameObj {
public:
	~VehicleGameObj();
	virtual void On_Post_Load();
	virtual PersistFactoryClass &Get_Factory();
	bool Save(ChunkSaveClass &);
	bool Load(ChunkLoadClass &);
	virtual void Init();
	virtual void Think();
	virtual void Post_Think();
	VehicleGameObj *As_VehicleGameObj();
	void Export_Creation(BitStreamClass &);
	void Import_Creation(BitStreamClass &);
	virtual void Apply_Damage(const OffenseObjectClass &, float, int);
	virtual int Get_Player_Type();
	virtual void Startup();
	virtual int Object_Expired(PhysClass *);
	void Export_Rare(BitStreamClass &);
	void Import_Rare(BitStreamClass &);
	void Export_Frequent(BitStreamClass &);
	void Import_Frequent(BitStreamClass &);
	virtual void Import_State_Cs(BitStreamClass &);
	virtual void Export_State_Cs(BitStreamClass &);
	virtual bool Set_Targeting(const Vector3 &, bool);
	virtual SoldierGameObj *Get_Weapon_Controler_Owner();
	virtual void Apply_Control();
	virtual Matrix3D *Get_Look_Transform();
	virtual void Get_Velocity(Vector3 &);
	virtual float Get_Stealth_Fade_Distance();
	virtual bool Use_2D_Aiming();
	virtual bool Is_Aircraft();
	virtual bool Is_Turret();
	virtual bool Is_Entry_Permitted(SoldierGameObj *);
	void Get_Description(StringClass &);
	float Get_Filter_Distance();
	SoldierGameObj *Get_Driver(void);
	void Add_Occupant(SoldierGameObj *);
	void Add_Occupant(SoldierGameObj *, int);
	SoldierGameObj *Get_Actual_Gunner();
	bool Contains_Occupant(SoldierGameObj *);
	int var970; // 0x970
	int Engine_Sound_State; // 0x974
	int var978; // 0x978
	int Turret_Count; // 0x97C
	bool Detonate_C4; // 0x980
	float TurretFacing; // 0x984
	float var988; // 0x988
	int var98C; // 0x98C
	bool Transition_Enabled; // 0x990
	bool Allow_ReCreate_Transitions; // 0x991
	bool Is_Transition_Available; // 0x992
	bool Delivered; // 0x993
	bool DefaultDriverIsGunner; // 0x994
	bool VehicleCanEnemySeen; // 0x995 - Note: This variable will only work if bhs.dll version is >= 3.4 or NC.dll version >= 0.3
	VectorClass<PersistantSurfaceEmitterClass *> SurfaceList; // 0x998
	PersistantSurfaceSoundClass *Persistant_Sound; // 0x9A8
	VectorClass<SoldierGameObj *> SeatsList; // 0x9AC
	int Occupant_Count; // 0x9BC
	DynamicVectorClass<TransitionInstanceClass *> TransitionList; // 0x9C0
	ReferencerClass Owner; // 0x9D8
	float OwnerExpireCounter; // 0x9E8
};

class SAMSiteGameObjDef : public SmartGameObjDef {
public:
	// No variable
};
class SAMSiteGameObj : public SmartGameObj {
public:
	int unks1; // 0x970
	int unks2; // 0x974
	int State; // 0x978
};

class TransitionGameObjDef : public BaseGameObjDef {
public:
	~TransitionGameObjDef();
	PersistFactoryClass &Get_Factory();
	bool Save(ChunkSaveClass &csave);
	bool Load(ChunkLoadClass &cload);
	unsigned long Get_Class_ID();
	PersistClass *Create();
	DynamicVectorClass<TransitionDataClass *> Transitions;
};
class TransitionGameObj : public BaseGameObj {
public:
	~TransitionGameObj();
	void On_Post_Load();
	PersistFactoryClass &Get_Factory();
	bool Save(ChunkSaveClass &csave);
	bool Load(ChunkLoadClass &cload);
	void Init();
	DynamicVectorClass<TransitionInstanceClass *> Transitions;
	Matrix3D Transform;
	int LadderIndex;
};

class DamageZoneGameObjDef : public BaseGameObjDef {
public:
	~DamageZoneGameObjDef();
	PersistFactoryClass &Get_Factory();
	bool Save(ChunkSaveClass &csave);
	bool Load(ChunkLoadClass &cload);
	unsigned long Get_Class_ID();
	PersistClass *Create();
	float DamageRate; // 0x1C
	int DamageWarhead; // 0x20
	Vector3 Color; // 0x24
};
class DamageZoneGameObj : public BaseGameObj {
public:
	~DamageZoneGameObj();
	PersistFactoryClass &Get_Factory();
	bool Save(ChunkSaveClass &csave);
	bool Load(ChunkLoadClass &cload);
	void Init();
	void Think();
	OBBoxClass BoundingBox; // 0x6C4
	float Time; // 0x700
};

class BulletClass : public CombatPhysObserverClass, public MultiListObjectClass, public PostLoadableClass {
public:
	~BulletClass();
	virtual int Collision_Occured(const CollisionEventClass &);
	virtual int Object_Expired(PhysClass *);
	int var14;
	ReferencerClass Owner; // 0x18
	//bool IsDead; // 0x44
	//bool IsAlive; // 0x4C
	//ProjectileClass *Projectile; // 0x50
	//ReferencerClass var60;
};
class BulletManager {
public:
	MultiListClass<BulletClass *> LiveBullets;
};

class VehicleDriverClass {
public:
	~VehicleDriverClass();
	Vector3 DestPosition; // 0x0
	Vector3 NextPosition; // 0xC
	int unkvd1; // 0x18
	void *unkvd2; // 0x1C
	float MaxSpeed; // 0x20
	float SpeedFactor; // 0x24
	float ArriveDist; // 0x28
};

class SpawnerDefClass : public DefinitionClass {
public:
	DynamicVectorClass<int> SpawnIDList; // 0x1C
	int PlayerType; // 0x34
	int SpawnMax; // 0x38
	float SpawnDelay; // 0x3C
	float SpawnDelayVariation; // 0x40
	bool IsPrimary; // 0x44
	bool IsSoldierStartup; // 0x45
	bool GotoSpawnerPos; // 0x46
	float GotoSpawnerPosPriority; // 0x48
	bool TeleportFirstSpawn; // 0x4C
	int SpecEffectsObjID; // 0x50
	int unk; // 0x54
	bool StartsDisabled; // 0x58
	bool KillHibernatingSpawn; // 0x59
	bool ApplySpawnMaterialEffect; // 0x5A
	bool IsMultiplayWeaponSpawner; // 0x5B
	DynamicVectorClass<StringClass> Observers; // 0x5C
	DynamicVectorClass<StringClass> ObserversParameter; // 0x74
};
class SpawnerClass : public PersistClass {
public:
	int ID; // 0x8
	Matrix3D TM; // 0xC
	Matrix3D SpawnTM; // 0x3C
	SpawnerDefClass *Definition; // 0x6C
	ReferencerClass SpawnQueue; // 0x70
	bool Enable; // 0x80
	int SpawnCount; // 0x84
	float SpawnDelay; // 0x88
	DynamicVectorClass<Matrix3D> SpawnTMList; // 0x8C
	DynamicVectorClass<StringClass> Observers; // 0xA4
	DynamicVectorClass<StringClass> ObserversParameter; // 0xBC
};
class SpawnManager {
public:
	static int &Total_Spwaner;
	static DynamicVectorClass<SpawnerClass *> &SpawnerList;
};

ArmedGameObj *As_ArmedGameObj(GameObject *obj);
BuildingGameObj *As_BuildingGameObj(GameObject *obj);
BeaconGameObj *As_BeaconGameObj(GameObject *obj);
C4GameObj *As_C4GameObj(GameObject *obj);
PowerUpGameObj *As_PowerUpGameObj(GameObject *obj);
PhysicalGameObj *As_PhysicalGameObj(GameObject *obj);
RefineryGameObj *As_RefineryGameObj(GameObject *obj);
ScriptableGameObj *As_ScriptableGameObj(GameObject *obj);
SmartGameObj *As_SmartGameObj(GameObject *obj);
SoldierGameObj *As_SoldierGameObj(GameObject *obj);
VehicleGameObj *As_VehicleGameObj(GameObject *obj);
VehicleFactoryGameObj *As_VehicleFactoryGameObj(GameObject *obj);

bool Is_C4(GameObject *);
bool Is_Soldier(GameObject *obj);
bool Is_Vehicle(GameObject *obj);
GameObject *Get_Vehicle(GameObject *obj);
GameObject *Get_Vehicle_Return(GameObject *obj);
void Set_Max_Health(GameObject *obj, float Max);
void Set_Max_Shield_Strength(GameObject *obj, float Max);
void Display_Scripts(ScriptableGameObj *obj);
bool Is_Script_Attached(GameObject *obj,const char *script);
void Remove_Script(GameObject *obj, const char *script);
const char *Get_Model(GameObject *obj);
float Get_Refinery_Income_Dump(int Team);
void Set_Refinery_Income_Dump(int Team, float Amount);
float Get_Refinery_Income_Tick(int Team);
void Set_Refinery_Income_Tick(int Team, float Amount);

#endif
