package PrivateChatHookPlugin;

# Brenbot Support for Neijwiert's PrivateChatHook Plugin
# Created by Blacky aka BigWrench.
# Brenbot 1.53 Compatibility

use strict;
use plugin;
use POE;

# Automatically sets the plugin name
our $plugin_name;
# Automatically imports the plugins config (from the xml file) into %config
our %config;
our $dbh; # Database connection
my $currentVersion = 1.00;
my $admin_channel = 'A';
my $Space_exploration = 1; #load_ok.
my $BBuild = 0;

# Check bot compatibility
if ( plugin::getBrVersion() >= 1.54 && plugin::getBrBuild() >= 248 ) #This build has private channel feature; 
	{ $admin_channel = 'M'; $BBuild = 1; } #Send messages to a private channel instead of admin.

# Definitely not going to work with versions older then 1.53
if ( plugin::getBrVersion() < 1.53 )
	{ $Space_exploration = 0 }

our %additional_events = (
    "gamelog_privatechat" => "gamelog_privatechat",
	"renlog_pchall" => "renlog_pchall",
	"pch" => "pch"
);

#######################
# Plugin Events
#######################

sub start
{
	my ( $session, $heap, $args ) = @_[ SESSION, HEAP, ARG0 ];
	my $kernel = $_[KERNEL];
	
	# Set our current version in the globals table
	plugin::set_global ( "version_plugin_pch", $currentVersion );
	
	# Connect to, and if necessary create, the database
	my ($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,$atime,$dbTime,$ctime,$blksize,$blocks) = stat( 'pch.dat' );
	$dbh = DBI->connect("dbi:SQLite:dbname=pch.dat","","");
	
	if( !$dbTime )
	{
		print "PCH PLUGIN :: Database does not exist, creating new database.\n";
		
		$dbh->do(

			"CREATE TABLE pch
			(id				INTEGER PRIMARY KEY AUTOINCREMENT 
			,name			CHAR(128)
			,ip				CHAR(45) )"
		);
		
		$dbh->do(
			"CREATE TABLE globals
			(id				INTEGER PRIMARY KEY AUTOINCREMENT 
			, name			TEXT
			, value			TEXT )"
		);
		
		$dbh->do( "INSERT INTO globals ( name, value ) VALUES ( 'version', '1.0' )" );
	}
	
	return $Space_exploration;
}


sub stop
{
	my ( $session, $heap, $args ) = @_[ SESSION, HEAP, ARG0 ];
	my $kernel = $_[KERNEL];
	$dbh->disconnect;
}

sub playerjoin
{
	my ( $session, $heap, $args ) = @_[ SESSION, HEAP, ARG0 ];
	my $kernel = $_[KERNEL];
	my %args = %{$args};
	my ( $p, %player ) = plugin::getPlayerData ( $args{nick} );
	if ( $p ) 
	{
		my $result = $dbh->selectrow_array ( "SELECT * FROM pch WHERE LOWER(name) = '$player{'name'}' OR ip = '$player{'ip'}'" );
		if ( $result)
		{
			plugin::RenRemCMD( "PCHADD $player{'id'}" );
		}
	}
}

sub command
{
  my %args = %{$_[ARG0]};
  $_[KERNEL]->yield ( $args{'command'} => \%args );
}

############################
# gamelog and renlog events
############################

sub gamelog_privatechat
{
    my ( $kernel, $session, $heap, $args ) = @_[ KERNEL, SESSION, HEAP, ARG0 ];
    my $line = $args->{line};
	my @splitted = split (";", $line);
	my $type = $splitted[1];
	my $sender = $splitted[2];
	my $receiver = $splitted[3];
	my $message = $splitted[4];
	my $sender_name = gamelog::getPlayerFromObjectID($sender);
	my $receiver_name = gamelog::getPlayerFromObjectID($receiver);
	return if (!defined($sender_name) || !defined($receiver_name) );
	my $color = get_color_player($sender_name);
	plugin::ircmsg ( "09[PRIVATECHAT]$color $sender_name -> $receiver_name: $message", $admin_channel );
	# Not compatible with brenbot 1.53.
	#logsystem::Log( logsystem->PRIVATE, "$sender_name -> $receiver_name: $message" );
}

#renlog_pchall renlog capture of the output of pchall
sub renlog_pchall
{
    my ( $kernel, $session, $heap, $args ) = @_[ KERNEL, SESSION, HEAP, ARG0 ];
    my $line = $args->{line};
	if ( $line =~ m/^.+\s\(\d\)$/ )
	{ 
		plugin::ircmsg ( "$line", $admin_channel ); 
	}
}

#######################
# Commands
#######################

sub pch
{
	my %args = %{$_[ ARG0 ]};
	eval
	{
		if ( $BBuild == 1 && $args{'ircChannelCode'} eq "A" )
		{
			send_message("Unable to execute command in this channel.", $args{nicktype}, $args{'ircChannelCode'}, $args{nick} );
			return;
		}
		
		if ($args{arg} =~ /^\!pch\s(.+)\s(.+)/i || $args{arg} =~ /^\!pch\s(.+)/i)
	 	{
			my $c = $1;
			my $p = $2;
			my $pid = 0;
			my $name = "";
			my $ip = "";
			if ( !$p && lc($c) ne "all" && lc($c) ne "list" )
			{
				show_syntax_error(@_);
				return;
			}
			
			if ( $p )
			{
				my ( $result, %player ) = playerData::getPlayerData( $p );
				if ( $result == 1 )
				{
					$pid = $player{'id'}; 
					$name = $player{'name'};
					$ip = $player{'ip'};
				}
				else
				{	
					if ( lc($c) ne "del" )
					{
						send_message("Unable to find player $p ingame.", $args{nicktype}, $args{'ircChannelCode'}, $args{nick} ); 
						return;
					}
				}
			}
			
			if ( lc($c) eq "all" )
			{
				plugin::RenRemCMD( "PCHALL");
				plugin::ircmsg ( "09Private chat Mesages will show for the following players.", $admin_channel );
				#renlog_pchall
			}
			elsif ( lc($c) eq "list" )
			{
				send_message("09Listing players in the PCH database.", $args{nicktype}, $args{'ircChannelCode'}, $args{nick} ); 
				my @pch = execute_query_database( "SELECT * FROM pch", $dbh ); # We use this because we want an array of hash references
				if (scalar(@pch) == 0)
				{
					send_message( "No players in the PCH database.", $args{nicktype}, $args{'ircChannelCode'}, $args{nick} );
					return;
				}
				foreach(@pch) {
					send_message( "($_->{'id'}) $_->{'name'} $_->{'ip'}", $args{nicktype}, $args{'ircChannelCode'}, $args{nick} ); 
				}
			}			
			elsif ( lc($c) eq "add" )
			{
				plugin::RenRemCMD( "PCHADD $pid");
				plugin::ircmsg ( "09$name added to the private chat monitoring list.", $admin_channel );
				my $exists = $dbh->selectrow_array ( "SELECT name FROM pch WHERE name = '$name'" );
				if (!$exists)
				{
					$dbh->do( "INSERT INTO pch ( name, ip ) VALUES ( '$name', '$ip' )" );
				}
				else
				{
					send_message("$name already exists in the PCH database.", $args{nicktype}, $args{'ircChannelCode'}, $args{nick} );
				}
			}
			elsif ( lc($c) eq "remove" )
			{
				plugin::RenRemCMD( "PCHREMOVE $pid");
				plugin::ircmsg ( "09$name removed from the private chat monitoring list.", $admin_channel );
				my $exists = $dbh->selectrow_array ( "SELECT name FROM pch WHERE name = '$name'" );
				if( $exists )
				{
					$dbh->do( "DELETE FROM pch WHERE LOWER(name)= '$name'" );
					send_message("Deleted PCH for $name", $args{nicktype}, $args{'ircChannelCode'}, $args{nick} );
				}
				else
				{
					send_message("PCH for $name does not exist.", $args{nicktype}, $args{'ircChannelCode'}, $args{nick} );
				}
			}
			elsif ( lc($c) eq "del" )
			{
				my $exists = $dbh->selectrow_array ( "SELECT LOWER(name) FROM pch WHERE LOWER(name) = '$p' OR id = '$p'" );
				if( $exists )
				{
					$dbh->do( "DELETE FROM pch WHERE LOWER(name)= '$p' OR id = '$p'" );
					send_message("09Deleted PCH for $p", $args{nicktype}, $args{'ircChannelCode'}, $args{nick} );
					my ( $result, %player ) = playerData::getPlayerData( $p );
					plugin::RenRemCMD( "PCHREMOVE $player{'id'}") if ( $result == 1 );
				}
				else
				{
					send_message("PCH for $p does not exist in the database.", $args{nicktype}, $args{'ircChannelCode'}, $args{nick} );
				}
			}
			else
			{
				send_message("Unknown PCH Command $c: ALL, ADD, REMOVE, DEL, LIST.", $args{nicktype}, $args{'ircChannelCode'}, $args{nick} );
			}
		}
		else { show_syntax_error(@_); }
	}
	or modules::display_error($@);
}

#######################
#### Utility Functions
#######################

sub show_syntax_error()
{
  my %args = %{$_[ ARG0 ]};
  my $syntax = 'Usage: '.$args{'settings'}->{'syntax'}->{'value'};

  if ( $args{'nicktype'} == 0 )
    { plugin::pagePlayer( $args{'nick'}, 'BRenBot', $syntax ); }
  elsif ( $args{'nicktype'} == 1 )
    { plugin::ircmsg( $syntax, $args{'ircChannelCode'} ); }
  else
    { plugin::console_output('A plugin used incorrect command syntax for '.$args{'command'}); }
}

#Not included in Brenbot 1.53

sub execute_query_database
{
	$| = 1;
	my $sth;
	my $query = shift;
	my $database = shift;
	my $flag = shift;
	$sth = $database->prepare ( "$query" );
	$sth -> execute;
	if (!$flag)
	{
		my $attrib_nr = 0;
		my @array_of_hash_refs;
		my @new_array;
		my $db_line;
	    while ($db_line = $sth->fetchrow_hashref())
	    {
	    	$array_of_hash_refs[$attrib_nr] = $db_line;
			$attrib_nr++;
		}
		undef $attrib_nr;
		foreach (@array_of_hash_refs)
		{
			my %hash = %$_;
			my %hash_lc;
			while ((my $k, my $v) = each %hash)
			{ 
				 $k = lc($k);
				 $hash_lc{$k} = $v;
			}
			push (@new_array,\%hash_lc);
		}
		$#array_of_hash_refs = -1;
		return (@new_array);
	}	
}

sub send_message
{
	my ( $msg, $nicktype, $chantype, $username, $irc_type, $ingame_type ) = @_;
	
	$irc_type = 1 if (! defined $irc_type); 
	$ingame_type = 1 if (! defined $ingame_type); 
	if ($nicktype == 1)
	{
		brIRC::ircmsg ($msg, $chantype ) if ( $irc_type <= 0 ); #Defualt
		brIRC::ircmsg ($msg, $chantype ) if ( $irc_type == 1 ); #reg irc msg
		brIRC::ircnotice ($username, $msg ) if ( $irc_type == 2 ); #irc notice
		brIRC::ircpm ($username, $msg ) if ( $irc_type == 3 ); #pm irc user
		#brIRC::ircpm_relaybot ($msg ) if ( $irc_type == 4 ); #pm the relay bot
		#brIRC::ircpm_moderators ($msg ) if ( $irc_type == 5 ); #pm all moderators
	}
	else
	{
		my ( $result, %player ) = playerData::getPlayerData( $username );
		if ( $result == 1 )
		{
			fds::send_message_player( $msg, $username, "Brenbot" ) if ( $ingame_type <= 0 );
			fds::send_message_player( $msg, $username, "Brenbot" ) if ( $ingame_type == 1 ); #ppage
			fds::send_message( $msg, $username ) if ( $ingame_type == 2 ); #send message to all players
			fds::send_admin_message( $msg, $username ) if ( $ingame_type == 3 ); #send admin message all players
		}
	}
}

sub get_color_player
{
	my $p = shift;
	my $color = "0";
	my ( $result, %player ) = playerData::getPlayerData ( $p );
	if ( $result == 1 )
	{
		my $p = $player{'teamid'};
		if ($p == 0) { 
			$color = "04"; 
		}
		elsif ($p == 1) { 
			$color = "08";
			$color = "10" if ( $main::currentMod eq "APB" );
		}
		elsif ($p == 2) { 
			$color = "15";
		}
		else {
			$color = "00"; 
		}	
	}
	return $color;
}

1;
