/*	Renegade Scripts.dll
	Scripts by Mark "Shawk" Sararu
	Copyright 2007 Mark "Shawk" Sararu, Jonathan Wilson

	This file is part of the Renegade scripts.dll
	The Renegade scripts.dll is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2, or (at your option) any later
	version. See the file COPYING for more details.
	In addition, an exemption is given to allow Run Time Dynamic Linking of this code with any closed source module that does not contain code covered by this licence.
	Only the source code to the module(s) containing the licenced code has to be released.
*/
#include <fstream>
#include "scripts.h"
#include "engine.h"
#include "shawk.h"

void SH_PCT_Custom::Custom(GameObject *obj,int message,int param,GameObject *sender)
{
	if (message == Get_Int_Parameter("Message"))
	{
		if (!Commands->Get_Player_Type(sender))
		{
			Display_NOD_Player_Terminal_Player(sender);
		}
		else
		{
			Display_GDI_Player_Terminal_Player(sender);
		}
	}
}

void SH_PCT_Powerup::Custom(GameObject *obj,int message,int param,GameObject *sender)
{
	if (message == CUSTOM_EVENT_POWERUP)
	{
		if (!Commands->Get_Player_Type(sender))
		{
			Display_NOD_Player_Terminal_Player(sender);
		}
		else
		{
			Display_GDI_Player_Terminal_Player(sender);
		}
	}
}

void SH_ConsoleCommand::Created(GameObject *obj) 
{
	Commands->Start_Timer(obj,this,0.1f,1);
}

void SH_ConsoleCommand::Timer_Expired(GameObject *obj,int number)
{
	char CommandRead[300];
	std::ifstream cc ("ConsoleCommand.txt");
	if (cc.is_open())
	{
		while (!cc.eof())
		{
			cc.getline(CommandRead,300);
			if (CommandRead[0] != '\0')
			{
				Console_Input(CommandRead);
			}
		}
		cc.close();
		if(!remove("ConsoleCommand.txt"))
		{
			Commands->Start_Timer(obj,this,0.1f,0);	
		}
	}

}

void SH_Spawn_Difficulty::Created(GameObject *obj)
{
	int level = Commands->Get_Difficulty_Level();
	if (level == 1)
	{
		if (Get_Int_Parameter("ObjectEasyEnabled") == 1)
		{
			GameObject *newObj = Commands->Create_Object(Get_Parameter("ObjectEasy"),Commands->Get_Position(obj));
			Commands->Set_Facing(newObj,Commands->Get_Facing(obj));
		}
	}
	else if (level == 2) 
	{
		if (Get_Int_Parameter("ObjectMediumEnabled") == 1)
		{
			GameObject *newObj = Commands->Create_Object(Get_Parameter("ObjectMedium"),Commands->Get_Position(obj));
			Commands->Set_Facing(newObj,Commands->Get_Facing(obj));
		}
	}
	else if (level == 3)
	{
		if (Get_Int_Parameter("ObjectHardEnabled") == 1)
		{
			GameObject *newObj = Commands->Create_Object(Get_Parameter("ObjectHard"),Commands->Get_Position(obj));
			Commands->Set_Facing(newObj,Commands->Get_Facing(obj));
		}
	}
}

ScriptRegistrant<SH_ConsoleCommand> SH_ConsoleCommand_Registrant("SH_ConsoleCommand","");
ScriptRegistrant<SH_PCT_Powerup> SH_PCT_Powerup_Registrant("SH_PCT_Powerup","");
ScriptRegistrant<SH_PCT_Custom> SH_PCT_On_Custom_Registrant("SH_PCT_On_Custom","");
ScriptRegistrant<SH_Spawn_Difficulty> SH_Spawn_Difficulty_Created("SH_Spawn_Difficulty","ObjectEasy:string,ObjectEasyEnabled:int,ObjectMedium:string,ObjectMediumEnabled:int,ObjectHard:string,ObjectHardEnabled:int");
