/*	MiniHealthHUDItemClass
	Copyright 2009 Mark Sararu

	This file is part of the Renegade scripts.dll
	The Renegade scripts.dll is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2, or (at your option) any later
	version. See the file COPYING for more details.
	In addition, an exemption is given to allow Run Time Dynamic Linking of this code with any closed source module 
	that does not contain code covered by this licence.
	Only the source code to the module(s) containing the licenced code has to be released.
*/

#ifndef SHADERS_MINIHEALTHHUD_H_
#define SHADERS_MINIHEALTHHUD_H_

class MiniHealthHUDItemClass
{
protected:
	bool Enabled;

	Render2DClass*		Render2D;
	Render2DTextClass*	Render2DText;

	float				LastHealth;
	bool				FlashActive;
	unsigned int		EndFlashTime;
	unsigned int		EndBlinkTime;

	bool				ForceInfoDisplayDuringLowHealth;
	float				LowHealthThreshold;

	unsigned int		HealthInfoFlashDuration; // in msec
	unsigned int		LowHealthBlinkDuration;  // ^

	Vector2				BackgroundSize;
	Vector2				BackgroundPosition;
	RectClass			BackgroundUV;
	char *				BackgroundTextureFile;

	Vector2				TextPosition;
	char *				TextFontFile;

public:
	MiniHealthHUDItemClass();
	~MiniHealthHUDItemClass();
	void Load(INIClass* ini);
	void Render();
};

extern MiniHealthHUDItemClass MiniHealthHUD;

#endif